COMMENT +					 
	The object of this program is to parse the reply, if any, to a DSR.
Check for 'cursor position report'(CSR), the ansi system response to the 
'device status report' (DSR).  The CPR format is '[##;##;R' so check                                                  
for the important parts of the string, the ESC and the R, but ignore the 
line and column numbers returned along with the CPR.  Results are returned
in AX: 0 if Ansi present, 1 if not.

+			MASM 5.1 SOURCE

 DOSSEG						; New MASM default declarations
.MODEL LARGE, C 				; produce necessary segs
.DATA						; data segment

QUERY     DB      1BH,"[6n$"			; Device Status Report (DSR)
str1	  db	  10 dup(00)			; buffer for ansi string 					
UNQUERY   DB      4 DUP(8," ",8),"$"		; to clear string from display

EXTRN  main: far				; calling program
PUBLIC check_for_ansi				; declare this routine public

.CODE						; code segment directive
;
;    OUTPUTS:					; returned in AX
;      AX = 0 (ANSI Driver Found)		
;      AX = 1 (ANSI Driver Not Found)
;

check_for_ansi proc far			; far procedure

	push    DX                            	; Save Registers
        mov     DX, offset @data: QUERY       	; Output DSR to ANSI Driver
        mov     AH,9				; DOS Print screen function
        int     21H				; call DOS

        mov     AH,6                          	; DOS Direct display I/O function
        mov     DL,0FFH				; tell AL to accept input
        int     21H				; call DOS
        jz      ANSI_CK2	                ; If ZF = 1, AL = 0, & no ANSI
  	cmp     al,1BH				; Does AL = Escape ?
        jnz     ANSI_CK2			; No, goto ansi_ck2
	mov cx,8 				; yes, now get 8 bytes	
L1:
	mov	AH,6				; put next byte into AL     
        mov     DL,0FFH 			; set up DOS service
        int     21H				; call DOS
	cmp     al,"R"				; Ansi returns an R if loaded
	jz 	ansi_ck1			; If R found, show ansi loaded
	loop    L1				; not yet, get another byte
	jmp     short ansi_ck2			; no R found, exit no ansi
ansi_ck1:					; ansi found label
	xor     ax,ax				; code 0 if ansi found
	jmp     short ansi_ck3       		; exit
	
ANSI_CK2: 					; fix screen if no match
	mov     dx,offset unquery               ; Clear Query Code from Screen
        mov     ah,9				; print screen
        int     21H				; call DOS
        mov     ax,1                            ; Return Code = 1
ANSI_CK3: 
	pop     dx                              ; Restore Registers
        ret                                     ; Done


check_for_ansi endp

END     
