IPOWER_F PROC      NEAR
;**************************************************************
;                       raises floating point mantissa pointed
;                       by DI to 16 bit integer exponent pointed
;                       to by SI
;**************************************************************
         PUSH      SI
         PUSH      DI
         SUB       AX,AX              ;clear registers
         MOV       CX,AX
;                               get mantissa
         MOV       BX,[DI]            ;f.p. mantissa in CX:BX
         OR        CX,[DI]+2
         JNZ       E0          ;check for zero mantissa
         SUB       DX,DX              ;set result in DX:AX
         MOV       AX,DX              ;to zero
         JMP       EXIT               ;and return
;                               get result sign
E0:      MOV       DX,0080h           ;isolate sign
         AND       DX,CX              ;in DX
         PUSH      DX                 ;and save it
;                               get exponent
         MOV       DI,AX              ;clear DI
         OR        DI,[SI]            ;OR  exponent into DI
         MOV       SI,DI              ;save it temporarily in DI
         JS        E1                 ;jump if negative exponent
         JNZ       E2          ;check for zero exponent
         MOV       DX,8100H           ;zero--set result to 1
         MOV       AX,0
         POP       CX                 ;get sign
         OR        DX,CX              ;and restore it
         JMP       EXIT               ;and return
;
E1:      NEG       DI                 ;make exponent positive
;
E2:      MOV       IM1,AX             ;store Y--initially = +1
         MOV       IM1+2,8100H
         MOV       IM2,BX             ;store Z
         MOV       IM2+2,CX
;
         PUSH      SI                 ;save original exponent
;
E3:      SHR       DI,1               ;N=N/2
         JNC       E4                 ;jump if N was even
;                                compute Y=Z*Y
         PUSH      DI                 ;save N
         MOV       SI, OFFSET IM1     ;address of Y in SI
         MOV       DI, OFFSET IM2     ;address of Z in DI
         CALL      MUL_F              ;Y=Y*Z--product in DX:AX
         OR        BX,BX              ;check completion status
         JNZ       E8                 ;jump if error
         MOV       IM1,AX             ;store Y
         MOV       IM1+2,DX
;                                if N=0 then quit
         POP       DI                 ;get exponent
         OR        DI,DI
         JZ        E5
;                                compute Z*Z
E4:      PUSH      DI                 ;save N
         MOV       SI, OFFSET IM2     ;address of Z in SI
         MOV       DI,SI              ;and in DI
         CALL      MUL_F              ;Z*Z--product in DX:AX
         OR        BX,BX              ;check completion status
         JNZ       E8
         MOV       IM2,AX             ;store Z
         MOV       IM2+2,DX
         POP       DI
;
         JMP       E3                 ;repeat for next N
;                                compute reciprocal if
E5:      POP       CX                 ;original exponent
         OR        CX,CX
         JNS       E6                 ;was negative
         MOV       DX,8100H           ;set up dividend of 1
         SUB       AX,AX
         MOV       IM2,AX             ;put it in IM2
         MOV       IM2+2,DX
         MOV       SI, OFFSET IM1
         MOV       DI, OFFSET IM2
         CALL      DIV_F              ;reciprocal in DX:AX
         OR        BX,BX              ;check completion code
         JNZ       E9
;                                set result sign
E6:      POP       DI
         OR        DX,DI
         JMP       EXIT

;                                here if error
E8:      POP       DI                 ;pop stack
         POP       DI
E9:      POP       DI
         JMP       EXIT               ;and return
IPOWER_F ENDP