ASC32    PROC     NEAR
;***************************************************************
;                    Converts a 32-bit signed integer to ASCII
;                    SI points to integer; DI to ASCII last byte
;                    in ASCII location. BX returns offset to 
;                    first character (sign)
;****************************************************************
         PUSH     SI
         PUSH     DI
         SUB      DX,DX           ;clear DX & BX
         MOV      BX,DX
         MOV      AX,[SI]         ;get integer
         OR       DX,[SI]+2
;                            check sign
         MOV      SI," "          ;assume positive sign
         JNS      ASC32A          ;if number negative
         NOT      AX              ;make it positive
         NOT      DX
         ADD      AX,1
         ADC      DX,0
         MOV      SI,"-"          ;and set negative sign
;
ASC32A:  PUSH     SI              ;save sign
;                            break into two 3-4 digit integers
         MOV      BX,10000        ;decimal 10,000 in BX
         DIV      BX              ;divide integer by 10,000
;
         PUSH     AX              ;quotient--first 3 ASCII digits
         MOV      SI,OFFSET IM1   ;SI points to positive integer 
         MOV      IM1,DX          ;remainder in range 0-9,999
         CALL     ASC16           ;convert remainder to ASCII
;                            check for zero quotient
         POP      AX              ;get the quotient
         OR       AX,AX
         JZ       ASC32D          ;finished if it is zero
;                            adjust ASCII remainder
         MOV      CX,BX           ;pointer to ASCII sign in CX
         SUB      CX,DI           ;CX is count of ASCII digits
         ADD      CX,4            ;should be 4
         JZ       ASC32C          ;if it isn't
ASC32B:  MOV BYTE PTR [BX],"0"    ;fill it out with zeros
         DEC      BX
         LOOP     ASC32B
;                            convert quotient
ASC32C:  MOV      DI,BX           ;DI points to next position
         MOV      SI,OFFSET IM1   ;SI points to location of
         MOV      IM1,AX          ;quotient in memory
         CALL     ASC16           ;convert it
;                            set ASCII sign
ASC32D:  POP      SI              ;get sign
         MOV      AX,SI           ;put it in AL
         MOV      [BX],AL         ;and save it
         JMP      EXIT
ASC32    ENDP