/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1994 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <setjmp.h>
#include "dis.h"

char	*cc[] = {
	"T", "F", "HI", "LS", "CC", "CS", "NE", "EQ",
	"VC", "VS", "PL", "MI", "GE", "LT", "GT", "LE"
};
char	*bitd[] = {
	"TST", "CHG", "CLR", "SET"
};
char	*bitf[] = {
	"EXTU", "EXTS", "FFO", "INS"
};

/*
 * Buffers for printing instructions
 */
char	buf1[100];
char	buf2[100];
char	buf3[100];

addr_t	curlabel = 0;
int	pass;
int	valid;

FILE	*infp;
FILE	*outfp;
addr_t	pc = 0;
addr_t	ppc = 0;
addr_t	initialpc = 0;
int	chip = MC68000;
int	lower = 0;
int	minlen = 5;
int	onepass = 0;
int	sp = 0;
char	*afile = NULL;
char	*ffile = NULL;
char	*ifile = NULL;
char	*nfile = NULL;

jmp_buf	jmp;

int
main(int argc, char **argv)
{
	char	*progname = argv[0];
	int	status = 0;
	char	*ofile = NULL;

	while (--argc && **++argv == '-') {
		if (strcmp("-pc", *argv) == 0 && argc--) {
			initialpc = strtoul(*++argv, NULL, 0);
		} else if (strcmp("-00", *argv) == 0) {
			chip = MC68000;
		} else if (strcmp("-08", *argv) == 0) {
			chip = MC68008;
		} else if (strcmp("-10", *argv) == 0) {
			chip = MC68010;
		} else if (strcmp("-20", *argv) == 0) {
			chip = MC68020;
		} else if (strcmp("-30", *argv) == 0) {
			chip = MC68030;
		} else if (strcmp("-o", *argv) == 0 && argc--) {
			/*
			 * output pathname
			 */
			ofile = *++argv;
		} else if (strcmp("-i", *argv) == 0 && argc--) {
			/*
			 * open file containing offsets
			 * that *are* instructions
			 */
			ifile = *++argv;
		} else if (strcmp("-a", *argv) == 0 && argc--) {
			/*
			 * open file containing valid
			 * A-line (1010) instructions
			 */
			afile = *++argv;
		} else if (strcmp("-f", *argv) == 0 && argc--) {
			/*
			 * open file containing valid
			 * F-line (1111) instructions
			 */
			ffile = *++argv;
		} else if (strcmp("-n", *argv) == 0 && argc--) {
			/*
			 * open file containing offsets
			 * that are *not* instructions
			 */
			nfile = *++argv;
		} else if (strcmp("-all", *argv) == 0)
			onepass = INCONSISTENT;
		else if (strcmp("-allc", *argv) == 0)
			onepass = CONSISTENT;
		else if (strcmp("-sp", *argv) == 0)
			sp = 1;
		else if (strcmp("-l", *argv) == 0) {
			lower = 1;
#ifdef DEBUG
		} else if (strncmp("-d", *argv, 2) == 0) {
			extern int	debug;

			if (isdigit(argv[0][2]))
				debug = atoi(&argv[0][2]);
			if (debug == 0)
				debug = 1;
#endif
		} else if (strcmp("-s", *argv) == 0 && argc--) {
			minlen = atoi(*++argv);
			if (minlen < 2)
				minlen = 2;
		} else {
			fprintf(stderr, "%s: bad option: %s\n", progname,
			  *argv);
			exit(1);
		}
	}

	if (chip != MC68000
	  && chip != MC68008
	  && chip != MC68010
	  && chip != MC68020
	  && chip != MC68030) {
		fprintf(stderr, "%s: can't disassemble for a %d\n", progname,
		  68000 + chip);
		exit(1);
	}

	if (argc == 0 && onepass) {
		infp = stdin;
		if (setjmp(jmp) == 0)
			disassemble();
	} else if (argc == 1 || argc > 1 && !ofile) {
		argv--;
		while (argc--) {
			char	*sfile;
			char	*lastslash;
			size_t	len;
			size_t	extra;
		
			if ((infp = fopen(*++argv, "r")) == NULL) {
				perror(*argv);
				status++;
				continue;
			}
			if (ofile)
				sfile = ofile;
			else {
				if (lastslash = strrchr(*argv, '/'))
					*argv = lastslash + 1;
				len = strlen(*argv);
				extra = (len > 2 && argv[0][len - 2] == '.'
				  && argv[0][len - 1] == 'o') ? 0 : 2;
				if ((sfile = malloc(len + extra + 1)) == NULL) {
					perror(*argv);
					status++;
					(void)fclose(infp);
					continue;
				}
				strcpy(sfile, *argv);
				strcpy(&sfile[len - 2 + extra], ".s");
			}
			if ((outfp = fopen(sfile, "w")) == NULL) {
				perror(sfile);
				status++;
				(void)fclose(infp);
				continue;
			}
			if (setjmp(jmp) == 0)
				disassemble();
			(void)fclose(infp);
			(void)fclose(outfp);
			if (!ofile)
				free(sfile);
		}
	} else {
		fprintf(stderr,
  "Usage: %s [-00|-08|-10|-20|-30] [-a A-line-file] [-all[c]]\n", progname);
		fprintf(stderr,
  "[-f F-line-file] [-i instructionfile] [-l] [-n datafile] [-o outputfile]\n");
		fprintf(stderr,
  "[-pc initialpc] [-s minlength] file...\n");
		exit(1);
	}

	exit(status);
}
