/*
 *                 Author:  Christopher G. Phillips
 *              Copyright (C) 1994 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "dis.h"

#define F	0
#define A	1

struct afinst {
	word_t	inst;
	char	*name;
};

static int
afsort(const void *v1, const void *v2)
{
	struct afinst	*p1 = (struct afinst *)v1;
	struct afinst	*p2 = (struct afinst *)v2;

	if (p1->inst < p2->inst)
		return -1;
	else if (p1->inst > p2->inst)
		return 1;
	else
		return 0;
}

static char *
validafinst(int anotf, word_t word)
{
	static int		fileread[2] = { 0, 0 };
	static size_t		ninsts[2] = { 0, 0 };
	static struct afinst	*afinsts[2] = { NULL, NULL };
	struct afinst		*aftmp;
	size_t			i;

	if (anotf && !afile || !anotf && !ffile)
		return NULL;

	if (!fileread[anotf]) {
		FILE	*afp;

		fileread[anotf] = 1;
		if (afp = fopen(anotf ? afile : ffile, "r")) {
			char	afbuf[80];
			word_t	ul;
			char	*cp;

			while (fgets(afbuf, sizeof afbuf, afp)) {
				afbuf[strlen(afbuf) - 1] = '\0'; /* zap '\n' */
				ul = strtoul(afbuf, &cp, 16);
				if (cp == afbuf
				  || (anotf && (ul < 0xa000 || ul > 0xafff))
				  || (!anotf && (ul < 0xf000 || ul > 0xffff))) {
					fprintf(stderr,
					  "File %s: bad inst: %s\n",
					    anotf ? afile : ffile, afbuf);
					continue;
				}
				cp--;
				while (*++cp && isspace(*cp))
					;
				if (!cp)
					cp = "UNKNOWN";
				if ((aftmp = realloc(afinsts[anotf],
				  ++ninsts[anotf] * sizeof(*afinsts[anotf])))
				  == NULL
				  || (aftmp[ninsts[anotf] - 1].name
				  = malloc(strlen(cp) + 1)) == NULL) {
					if (aftmp)
						afinsts[anotf] = aftmp;
					perror("realloc");
					return NULL;
				} else {
					afinsts[anotf] = aftmp;
					afinsts[anotf][ninsts[anotf] - 1].inst
					  = ul;
					strcpy(
					 afinsts[anotf][ninsts[anotf] - 1].name,
					 cp);
				}
			}
			(void)fclose(afp);
			qsort(afinsts[anotf], ninsts[anotf],
			  sizeof(*afinsts[anotf]), afsort);
		} else
			perror(anotf ? afile : ffile);
	}
	for (i = 0; i < ninsts[anotf]; i++)
		if (word == afinsts[anotf][i].inst)
			return afinsts[anotf][i].name;

	return NULL;
}

void
aline(word_t word)
{
	char	*cp;

	if (cp = validafinst(A, word)) {
		instprint(ops2f(0), cp);
		valid = 1;
	}
}

void
fline(word_t word)
{
	char	*cp;

	if (cp = validafinst(F, word)) {
		instprint(ops2f(0), cp);
		valid = 1;
	}
}
