;********************************************************************
;	(c) Copyright 1989-1992 Magic Box Designs, David J. Crone
;	all rights reserved
;
; Filename: kbstuff.inc
;
; Function: Include file for assembly language files which are part
;               of the keyboard driver 
;
; NOTE:  This file has a '.h' equivalent.  If this file changes,
;        then the same changes need to be made to it.
;
; Author: David J. Crone
; Version: 2.0
; Last Edit:	23-Apr-90	DJC
;		22-Sep-89       DJC  End-Of-Interrupt definitions
;       	17-Aug-89       DJC  Creation
;
;********************************************************************


; --- keyboard flag bits --- 
INS_STATE       equ     80h
CAPS_STATE      equ     40h
NUM_STATE       equ     20h
SCROLL_STATE    equ     10h
ALT_SHIFT       equ     08h
CTL_SHIFT       equ     04h
LEFT_SHIFT      equ     02h
RIGHT_SHIFT     equ     01h


; --- keyboard flag_1 bits --- 
INS_SHIFT       equ     80h
CAPS_SHIFT      equ     40h
NUM_SHIFT       equ     20h
SCROLL_SHIFT    equ     10h
HOLD_STATE      equ     08h

; --- keyboard flag_2 bits --- 
KB_ERR_BIT      equ     80h
KB_LED_BIT      equ     40h
KB_RESEND_BIT   equ     20h
KB_ACK_BIT      equ     10h
; LED current state mask is 07h


; --- BIOS area addresses --- 
bios_head       equ     1Ah	;head ptr
bios_tail       equ     1Ch	;tail ptr
bios_buffer     equ     1Eh	;buffer
bios_end        equ     82h	;ptr to end of buffer
bios_start      equ     80h	;ptr to start of buffer
bios_flag       equ     17h
bios_flag_1     equ     18h
bios_flag_2     equ     97h
reset_flag	equ	72h	;system reset flag
BIOS_SEG        equ     40h	;bios data segment


;--- standard keyboard controller definitions --- 
pc_k_data       equ     60h     ;keyboard input/output data port
pc_k_control    equ     64h     ;keyboard controller port 
pc_k_status     equ     64h     ;keyboard controller status register 


; --- keyboard command codes --- 
; -   data port (60h) codes    - 
;These are sent to the keyboard unit 
KB_RESET        equ     0FFh    ;hard keyboard reset 
KB_RESEND       equ     0FEh    ;resend last command 
KB_ACK          equ     0FAh    ;ack 
KB_DEFAULT      equ     0F6h    ;set keyboard to defaults 
KB_DISABLE      equ     0F5h    ;disable keyboard 
KB_ENABLE       equ     0F4h    ;enable (soft reset) keyboard 
KB_RATE         equ     0F3h    ;set typematic rate 
KB_ECHO         equ     0EEh    ;echo 
KB_LED          equ     0EDh    ;set/reset keyboard leds
;These are received from the keyboard
KB_OVERRUN      equ     0FFh    ;keyboard character overrun
KB_BATDONE      equ     0AAh    ;BAT (Basic Assurance Test) done

; - control port (64h) commands -
; These are sent to the 8042 controller 
KC_READ         equ     20h     ;returns current command reg 
KC_WRITE        equ     60h     ;write next byte to command reg 
KC_SELFTEST     equ     0AAh    ;returns 55h if O.K. 
KC_INTERFACE    equ     0ABh    ;test clock & data lines 
KC_DUMP         equ     0ACh    ;dump controller's RAM 
KC_DISABLE      equ     0ADh    ;disable keyboard interface 
KC_ENABLE       equ     0AEh    ;enable keyboard interface 
KC_READIN       equ     0C0h    ;read input port 
KC_READOUT      equ     0D0h    ;read output port 
KC_WRITEOUT     equ     0D1h    ;write output port 
KC_TESTIN       equ     0E0h    ;read test inputs 

; -  status port (64h) bits  -
KS_OBF          equ     01h     ;output buffer full 
KS_IBF          equ     02h     ;input buffer full 
KS_SYSFLAG      equ     04h     ;system flag 
KS_COMMAND      equ     08h     ;next byte will go to command reg 
KS_INHIBIT      equ     10h     ;0=keyboard inhibited 
KS_TXTIMOUT     equ     20h     ;transmit timeout 
KS_RXTIMOUT     equ     40h     ;receive timeout 
KS_PARITY       equ     80h     ;parity error 


;----- end of kbstuff.inc -----

