;/* 
; * isconsole() - determines if a file handle is associated with the console.
; *
; *    Returns:
; *       0           Handle is not associated with the console
; *       non-zero    Handle is associated with the console
; */

;Toad Hall Rewrite from original C to good old .ASM
;Test program named TESTCON.ASM.
;Run with and without redirection
;(suggest TESTCON >NUL for redirection).
;Results will be displayed to the screen in any case
;(e.g., STDERR)
;
;David Kirschbaum
;Toad Hall

STDIN	EQU	0
STDOUT	EQU	1
STDERR	EQU	2

CR	EQU	0DH
LF	EQU	0AH

CSEG	SEGMENT PUBLIC PARA
	ASSUME	CS:CSEG,DS:CSEG

	ORG	100H

TestConsole	PROC	NEAR
	mov	ax,STDOUT
	push	ax			;parm on the stack
	call	isconsole		;see if it's associated with console
	mov	dx,offset is_msg	;'Is associated..'
	mov	cx,IS_LEN		;msg length
	or	ax,ax			;non-0 means TRUE
	jnz	Got_Result		;yep, true
	 mov	dx,offset not_msg	;'Is *not* associated..'
	 mov	cx,NOT_LEN		;msg length
Got_Result:
	mov	ah,40H			;write to file/device
	mov	bx,STDERR
	int	21H
	mov	ah,4CH			;terminate, ERRORLEVEL in AL
	int	21H


is_msg	db	'stdout is associated with the console',CR,LF
IS_LEN	EQU	$-is_msg
not_msg	db	'stdout is *not* associated with the console',CR,LF
NOT_LEN	EQU	$-not_msg

TestConsole	ENDP

INCLUDE	isconsol.asm

CSEG	ENDS
	END	TestConsole
