	page	60,132
;***********************************************************
;**    Configuration Program for Communications           **
;**    Copyright (C) Texas Instruments, Inc. 1986         **
;**                                                       **
;**    Author: Greg Haley                                 **
;**    Project Start: 09/15/86                            **
;**    Last Revision: 11/18/86                            **
;** 							  **
;**    Modifications: Joe McDaniel, Fein-Marquart	  **
;**	August, 1987					  **
;***********************************************************

	name	RS232
	title	Config Program for Serial Communications
cr	equ	0dH
lf	equ	0aH

code	segment
	assume	cs:code, ds:code, es:code, ss:code
	org	80h
char_count label byte
	org	81h
command_line label byte
	org	100h
RS232 	proc	near
	jmp 	start

; variables 
device	db	'AUX',6 dup (0)		; Device name
handle	dw	0			; Handle for AUX
DCW	dw	?			; Device configuration word
DCB	db	?			; Device Configuration Byte
c_line	db	256 dup (?)		; Copy of command line
count	dw	0			; Num. of chars in command line
	dw	40 dup (?)		; New stack
top_stack label word

msg:
	db	cr,lf,'RS232 Configuration Copyright (C) '
	db	'Texas Instruments 1986'
	db	cr,lf,'Author: Greg Haley',cr,lf
	db	'Revised: Joe McDaniel, Fein-Marquart Associates - 1987',cr,lf
	db	cr,lf,'Current serial configuration:'
   	db	cr,lf,'Port='
port_n	db	' , Speed='
speed	db	'    , Parity='
parity	db	'    , Data bits='
data	db	' , Stop bits='
stop	db	' , Busy='
busy	db	'        ',cr,lf
	db	'RI='
ringind	db	' , SP='
spind	db	' , DSR='
dsrind	db	' , CTS='
ctsind	db	' , DCD='
dcdind	db	' ','$'

busy_tbl dw	no_busy	
	dw	scf_busy
	dw	dsr_busy
	dw	xon_busy

no_busy	db	'NONE    '
scf_busy db	'SCF     '
dsr_busy db	'DSR     '
xon_busy db	'XON-XOFF'

p_tbl	dw	par_none
	dw	par_odd
	dw	par_none
	dw	par_even

par_none db	'NONE'
par_odd	db	' ODD'
par_even db	'EVEN'

s_tbl	dw	s_110
	dw	s_150
	dw	s_300
	dw	s_600
	dw	s_1200
	dw	s_2400
	dw	s_4800
	dw	s_9600
	dw	s_19200

s_110	db	'  110'
s_150	db	'  150'
s_300	db	'  300'
s_600	db	'  600'
s_1200	db	' 1200'
s_2400	db	' 2400'
s_4800	db	' 4800'
s_9600	db	' 9600'
s_19200	db	'19200'

; Program starts here
start:	
; set up new stack
	mov	sp,offset top_stack
	mov	ax,cs
	mov	ds,ax
	mov 	es,ax

; open handle
	mov	dx,offset device
	mov	ax,3d02h
	int	21h
	jnc	open_1
	jmp	error
open_1:
	mov	handle,ax
	mov	bx,ax

; get command line length
	mov	al,char_count
	or	al,al
	jnz	command_1
	jmp	display_dcw
command_1:
	cbw
	mov	count,ax

; get command line
	mov	cx,ax
	mov	si,offset command_line
	mov	di,offset c_line
copy_string:
	lodsb
	cmp	al,'a'			; Is it lower case?
	jb	upper_case		;  No, skip
	and	al,11011111b		;  Yes, convert to upper case
upper_case:
	stosb				; Store upper case value
	loop	copy_string		; Loop 'til done
	
; get DCW
	call	get_dcw
	jnc	get_dcw_1
	jmp	error
get_dcw_1:

; get DCB
	call	get_dcb
	jnc	get_dcb_1
	jmp	error
get_dcb_1:

; mask out the control line bits in the dcb
	and	dcb,11100000b

; look for word "port" ("po")
	mov	di,offset c_line
	mov	cx,count

port_again:
	mov	al,'P'
	repnz	scasb			; find string
	jcxz	port_done
	mov	si,di
	lodsb				; next char "O" ?
	cmp	al,'O'
	jne	port_again 		; No, look for others

	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	port_done

	mov	dl,'1'			; find port number
	mov	dh,'4'
	mov	si,di
get_port:
	lodsb
	cmp	al,dl			; port 1 <= port <= 4 ?
	jb 	loop_port
	cmp	al,dh
	jg	loop_port
	dec	al          		; convert port to binary
	and	al,00000011b
	jmp	port_dcw		; go change it
loop_port:
	loop	get_port


; modify DCW
port_dcw:
	and	dcw,1110011111111111b	; reset port bits
	mov	cl,11
	xor	ah,ah
	shl	ax,cl
	or	dcw,ax
port_done:	

; look for word "data" ("da")
	mov	di,offset c_line
	mov	cx,count
	mov	al,'D'
	repnz	scasb			; find string
	jcxz	data_done
	mov	si,di
	lodsb				; next char "A" ?
	cmp	al,'A'
	je	found_data		; Yes, continue
	jmp	data_done		; No, exit
found_data:
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	data_done

	mov	si,di
	lodsb
	cmp	al,'7'			; 7 data bits?
	jne	check_for_8
	and	dcw,1011111111111111b	; Store in proper bit
	jmp	data_done		; we're done
check_for_8:
	cmp	al,'8'                  ; 8 data bits
	jne	data_done		; 
	or 	dcw,0100000000000000b	; Store in proper bit
data_done:	

; look for word "busy" ("bu")
	mov	di,offset c_line
	mov	cx,count
	mov	al,'B'
	repnz	scasb			; find string
	jcxz	busy_done
	mov	si,di
	lodsb				; next char "U" ?
	cmp	al,'U'
	je	found_busy		; Yes, continue
	jmp	busy_done		; No, exit
found_busy:
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	busy_done

	mov	si,di
	lodsb
	cmp	al,'N'			; No busy handling?
	jne	busy_scf
	and	dcw,1111110011111111b	; Store in proper bits
	jmp	busy_done		; we're done
busy_scf:
	cmp	al,'S'			; SCF busy handling?
	jne	busy_dsr
	and	dcw,1111110011111111b	; Store in proper bits
	or 	dcw,0000000100000000b	; Store in proper bits
	jmp	busy_done		; we're done
busy_dsr:
	cmp	al,'D'			; No busy handling?
	jne	busy_xon
	and	dcw,1111110011111111b	; Store in proper bits
	or 	dcw,0000001000000000b	; Store in proper bits
	jmp	busy_done		; we're done
busy_xon:
	cmp	al,'X'			; No busy handling?
	jne	busy_done
	or 	dcw,0000001100000000b	; Store in proper bits
busy_done:	

; look for word "speed" ("sp")
	mov	di,offset c_line
	mov	cx,count
find_speed:
	mov	al,'S'
	repnz	scasb			; find string
	or	cx,cx			; too far a jump for 	jcxnz	speed_A
	jnz	speed_A
	jmp	speed_done

speed_A:
	mov	si,di
	lodsb				; next char "P" ?
	cmp	al,'P'
	jne	find_speed		; No, look again
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	or	cx,cx			; too far a jump for jcxnz	speed_2
	jnz	speed_B
	jmp	speed_done

speed_B:
	mov	si,di
	lodsb
	cmp	al,'1'			; 1 speed bit?
	jne	speed_2
	lodsb
	cmp	al,'1'			; 110 baud?
	jne	speed_150
	and	dcw,1111111100001111b	; Store in proper bits
	jmp	speed_done		; we're done
speed_150:
	cmp	al,'5'			; 150 baud?
	jne	speed_1200
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000000010000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_1200:
	cmp	al,'2'                  ; 1200 baud?
	jne	speed_19200
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000001000000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_19200:
	cmp	al,'9'                  ; 19200 baud?
	jne	speed_done
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000010000000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_2:
	cmp	al,'2'                  ; 2400 baud?
	jne	speed_3
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000001010000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_3:
	cmp	al,'3'                  ; 300 baud?
	jne	speed_4
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000000100000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_4:
	cmp	al,'4'                  ; 4800 baud?
	jne	speed_6
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000001100000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_6:
	cmp	al,'6'                  ; 600 baud?
	jne	speed_9
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000000110000b	; Store in proper bits
	jmp	speed_done		; we're done
speed_9:
	cmp	al,'9'                  ; 9600 baud?
	jne	speed_done
	and	dcw,1111111100001111b	; Store in proper bits
	or 	dcw,0000000001110000b	; Store in proper bits
speed_done:	

; look for word "stop" ("st")
	mov	di,offset c_line
	mov	cx,count
find_stop:
	mov	al,'S'
	repnz	scasb			; find string
	jcxz	stop_done
	mov	si,di
	lodsb				; next char "T" ?
	cmp	al,'T'
	jne	find_stop		; No, try next
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	stop_done

	mov	si,di
	lodsb
	cmp	al,'1'			; 1 stop bit?
	jne	stop_2
	and	dcw,1111111111110111b	; Store in proper bit
	jmp	stop_done		; we're done
stop_2:
	cmp	al,'2'                  ; 2 stop bits
	jne	stop_done		; 
	or 	dcw,0000000000001000b	; Store in proper bit
stop_done:	

; look for word "parity" ("pa")
	mov	di,offset c_line
	mov	cx,count
find_parity:
	mov	al,'P'
	repnz	scasb			; find string
	jcxz	parity_done
	mov	si,di
	lodsb				; next char "A" ?
	cmp	al,'A'
	jne	find_parity		; No, look again
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	parity_done

	mov	si,di
	lodsb
	cmp	al,'N'			; No parity?
	jne	parity_odd
	and	dcw,1111111111111100b	; Store in proper bits
	jmp	parity_done		; we're done
parity_odd:
	cmp	al,'O'			; ODD parity?
	jne	parity_even
	and	dcw,1111111111111100b	; Store in proper bits
	or 	dcw,0000000000000001b	; Store in proper bits
	jmp	parity_done		; we're done
parity_even:
	cmp	al,'E'			; EVEN parity?
	jne	parity_done
	or 	dcw,0000000000000011b	; Store in proper bits
parity_done:	

; search for the DCB settings, too
; look for word "FLush"
	mov	di,offset c_line
	mov	cx,count
	mov	al,'F'
	repnz	scasb			; find string
	jcxz	fl_done
	mov	si,di
	lodsb				; next char "L" ?
	cmp	al,'L'
	jne	fl_done 		; No, look for others
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	fl_done

	mov	si,di
	lodsb
	and	dcb,11111101b		; assume 0 (off)
	cmp	al,'1'			; 1 ?
	jne 	fl_done
	or	dcb,00000010b		; set it on
fl_done:	

; look for word "DTr"
	mov	di,offset c_line
	mov	cx,count
	mov	al,'D'
	repnz	scasb			; find string
	jcxz	dtr_done
	mov	si,di
	lodsb				; next char "T" ?
	cmp	al,'T'
	jne	dtr_done 		; No, look for others
	mov	al,'='			; Now look for "=" char
	repnz	scasb
	jcxz	dtr_done

	mov	si,di
	lodsb
	or	dcb,00000001b		; assume 1 (on)
	cmp	al,'0'			; 0 ?
	jne 	dtr_done
	and	dcb,11111110b		; set it off
dtr_done:	


; Turn on Serial bit in DCW
	or 	dcw,1000000000000000b

; Set new DCB
 	mov	dx,offset DCB
 	mov	bx,handle
 	mov	cx,1
 	mov	ax,4403h
 	int	21h

; Set new DCW
	mov	dx,offset DCW
	mov	bx,handle
	mov	cx,2
	mov	ax,4403h
	int	21h

; display current DCW and DCB
display_dcw:
	call	get_dcw
	call	get_dcb
	call	print_dcw

; terminate program
exit: 
	mov	al,0
	jmp 	short terminate
error:
	mov	al,1
terminate:
	mov	ah,4ch
	int	21h

; Get Device Config Word
get_dcw	proc	near
	mov	dx,offset DCW
	mov	bx,handle
	mov	cx,2
	mov	ax,4402h
	int	21h
	ret
get_dcw	endp

; Get Device Config Byte
get_dcb	proc	near
	mov	dx,offset DCB
	mov	bx,handle
	mov	cx,1
	mov	ax,4402h
	int	21h
	ret
get_dcb	endp

print_dcw proc 	near
; insert port number
	mov	dx,dcw
	mov	cl,11
	shr	dx,cl
	and	dl,00000011b
	or	dl,00110000b
	inc	dl
	mov	port_n,dl

; insert speed
	mov	dx,dcw
	and	dx,0000000011110000b
	mov	cl,3
	shr	dl,cl
	mov	bx,offset s_tbl
	add	bx,dx
	mov	si,[bx]
	mov	di,offset speed
	mov	cx,5
	repz	movsb

; insert parity
	mov	dx,dcw
	and	dx,0000000000000011b
	shl	dx,1
	mov	bx,offset p_tbl
	add	bx,dx
	mov	si,[bx]
	mov	di,offset parity
	mov	cx,4
	repz	movsb

; insert data bits
	mov	dx,dcw
	mov	al,'7'
	and	dx,0100000000000000b
	jz	data_7
	inc	al
data_7:
	mov	data,al

; insert stop bits
	mov	dx,dcw
	mov	al,'1'
	and	dx,0000000000001000b
	jz	stopis2
	inc	al
stopis2:
	mov	stop,al

; insert busy
	mov	dx,dcw
	and	dx,0000001100000000b
	xchg	dl,dh
	shl	dx,1
	mov	bx,offset busy_tbl
	add	bx,dx
	mov	si,[bx]
	mov	di,offset busy
	mov	cx,8
	repz	movsb

; print dcb, too
; insert ring indicator status
	mov	dl,dcb
	mov	al,'0'
	and	dx,00010000b
	jz	ri2
	inc	al
ri2:
	mov	ringind,al

; insert modem speed indicator status
	mov	dl,dcb
	mov	al,'0'
	and	dx,00001000b
	jz	sp2
	inc	al
sp2:
	mov	spind,al

; insert dsr indicator status
	mov	dl,dcb
	mov	al,'0'
	and	dx,00000100b
	jz	dsri2
	inc	al
dsri2:
	mov	dsrind,al

; insert cts indicator status
	mov	dl,dcb
	mov	al,'0'
	and	dx,00000010b
	jz	cts2
	inc	al
cts2:
	mov	ctsind,al

; insert dcd indicator status
	mov	dl,dcb
	mov	al,'0'
	and	dx,00000001b
	jz	dcd2
	inc	al
dcd2:
	mov	dcdind,al

; print message
	mov	dx,offset msg
	mov	ah,9
	int	21h

	ret
print_dcw endp

RS232 	endp
code	ends
	end	RS232 
