;--------------------------------------------------------------------
; GetBaud Procedure for TASM - 08/26/93
; written by Dave Navarro, Jr.  (CIS 73002,3506)
;
;  This procedure is donated to the Public Domain with no
;  copyrights of any kind and may be used without restriction.
;
;  If you do make any changes, please send a copy to me on
;  Compuserve, either as electronic mail, or in the IBMPRO forum.
;
;--------------------------------------------------------------------
; GetBaud - Get the baud rate of the specified port
;       Call with:  Port number (1-4) on stack
;         Returns:  DX:AX baud rate of specified port


Code    Segment Byte
        Assume  CS: Code

HighBaud DD     115200

        Public  GetBaud

GetBaud Proc    Far

ARG     Port:   WORD = Retbytes

        push    BP                      ;
        mov     BP,SP                   ;
        push    DS                      ;

        xor     DX,DX                   ; clear DX
        mov     AX, Port                ; get port number
        or      AX,AX                   ; is it 0?
        jz      Exit                    ; yes, exit
        cmp     AX,4                    ; is it greater than 4?

        ja      Exit                    ; yes, exit
        shl     AX,1                    ; multiply it times 2
        add     AX,3FEh                 ; add 3FEh to it
        mov     DS,DX                   ; put segment into DS
        mov     BX,AX                   ; put offset into BX
        mov     DX, DS: [BX]            ; get port address

        add     DX,3                    ; line control register
        in      AL,DX                   ; get status
        push    AX                      ; save it
        or      AL,80h                  ; set Divisor Latch Bit on
        out     DX,AL                   ; turn on Divisor Latch Bit
        sub     DX,3                    ; port i/o address
        in      AL,DX                   ; get lsb of divisor

        mov     BL,AL                   ; save it
        inc     DX                      ; port i/o address + 1
        in      AL,DX                   ; get msb of divisor
        mov     BH,AL                   ; save it
        pop     AX                      ; get old status
        add     DX,2                    ; line control register
        out     DX,AL                   ; restore status

        mov     AX, Word ptr HighBaud+2 ; high part of maxium baud
        xor     DX, DX                  ; clear DX
        div     BX                      ; divide
        mov     CX, AX                  ; hold high part of result
        mov     AX, Word ptr HighBaud   ; DX has remainder of first half divide
        div     BX                      ; divide

        xchg    CX, DX                  ; result in DX:AX, remainder in CX
Exit:
        pop     DS                      ;
        pop     BP                      ;
        retf    RetBytes                ;
Getbaud EndP
Code    EndS
        End