Page 58, 80
comment |

 Date:           10/22/92
 Name:           Mul.asm
 Author:         Michael J. Steiner

 description:    Assembly function to multiply to long's
|

               .model   small
               .code

               public   _Multiply
_Multiply      proc

               push     bp
               mov      bp,sp
               sub      sp,0004                  ;stack alignment

               mov      cx,[ bp + 06h ]          ;lsb of number0
               mov      bx,[ bp + 04h ]          ;msb of number0
               mov      dx,[ bp + 0Ah ]          ;lsb of number1
               mov      ax,[ bp + 08h ]          ;msb of number1
               
               push     si                       ;save contents of si
               
               xchg     si,ax                    ;save ax in si
               xchg     dx,ax                    ;xchange ax and dx for test
               test     ax,ax                    ;check exist lsb number1
               jz       Skip1                    ;no bits set move on
               mul      bx                       ;yes lsb num1 * msb num0
Skip1:         
               jcxz     Skip2                    ;jump if lsb num0 is zero
               xchg     cx,ax                    ;no xchange ax and cx
               mul      si                       ;msb num1 * lsb num0
               add      ax,cx                    ;add first result to second
Skip2:         
               xchg     si,ax                    ;msb num1 back to ax,si result
               mul      bx                       ;msb num0 * msb num1
               add      dx,si                    ;add msb resutant to msb
                                                 ;return
               pop      si                       ;restore old si
               mov      sp,bp                    ;realign stack
               pop      bp                       ;restore old bp

               ret                               ;dx:ax holds return value
_Multiply      endp
               end
                