//**************************************************************************
//
// Date:         10/22/92
// Name:         Fp16.c
// Author:       Michael J. Steiner
//                CompuServe: [ 70304,3452 ]
//
// Description:  Demonstrats the advantage in time, of using fixed point
//               mathematics in place of floating point matematics. And
//               the disadvantage of loss of precision.
//
// Note:         Storage:                         Fraction
//                                Integer            
//                           Sign                   
//                                                 
//                            0                     
//                             000000000000000       
//                                            0000000000000000
//                   
//**************************************************************************

#include <stdio.h>
#include <time.h>

#define BITSHIFT      16                 //significant to 4 places
#define BITS          ( 1L << BITSHIFT ) //could use a constant here for
                                         //greater speed

#define LONG2DBL( a ) (double)a / BITS   //these two macros are the heart of
#define DBL2LONG( a ) (long)( a * BITS ) //the conversion double => integer

#define ADD( a, b )   LONG2DBL( ( DBL2LONG( a ) + DBL2LONG( b ) ) )
#define SUB( a, b )   LONG2DBL( ( DBL2LONG( a ) - DBL2LONG( b ) ) )
#define MUL( a, b )   LONG2DBL( ( ( DBL2LONG( a ) * \
                                             DBL2LONG( b ) ) >> BITSHIFT ) )

#define DIV( a, b )   LONG2DBL( ( ( DBL2LONG( a ) / \
                                             DBL2LONG( b ) ) << BITSHIFT ) )

extern long Add( long, long );
extern long Sub( long, long );  

void main( void )
{
 clock_t End, Start;
 double AddTime1, AddTime2;
 int x;
 double inc;
 double Value;
 double Result0, Result1, Result2;
 long   INC,VALUE;

 printf( "\n" );
 printf( "     Using the Macros\n" );
 printf( "     ----------------\n" );
 printf( "    (long) .11: %ld\n", DBL2LONG( .11 ) );
 printf( "    (long) .22: %ld\n", DBL2LONG( .22 ) );
 printf( "     .22 + .11: %2.4lf\n", ADD( .22, .11 ) ); 
 printf( "     .22 - .11: %2.4lf\n", SUB( .22, .11 ) );
 printf( "     .22 * .11: %2.4lf\n", MUL( .22, .11 ) );
 printf( "     .22 / .11: %2.4lf\n", DIV( .22, .11 ) );

 inc   = 1.11;
 Value = 0.22;

 INC   = DBL2LONG( 1.11 );
 VALUE = DBL2LONG( 0.22 );

 Start = clock();

 for( x=0; x<20000; x++ )
  {
   inc += Value;
   inc -= Value;
  }

 End = clock();
 AddTime1 = (double)( End - Start ) / CLK_TCK;

 Start = clock();

 for( x=0; x<20000; x++ )
  {
   INC += VALUE;
   INC -= VALUE;
  }

 End = clock();
 AddTime2 = (double)( End - Start ) / CLK_TCK;

 printf( "\n" );
 printf( "            Timed Addition/Subtraction Test\n" );
 printf( "\n" );
 printf( "      FLOATING POINT                  FIXED 16 POINT\n" );
 printf( "                             \n" );
 printf( "         Total: %4.4lf             Total: %4.4lf\n", inc, LONG2DBL( INC ) );
 printf( "          Time: %-2.2f               Time: %-2.2f\n", AddTime1, AddTime2 );
 printf( "Speed increase: %2.2f [%]\n", ( AddTime1 / AddTime2 ) * 100 );

}


