PROGTYPE   EQU  00000001b
DATATYPE   EQU  00000010b
CONSTYPE   EQU  00000100b
DIRETYPE   EQU  00001000b
REGSTYPE   EQU  00010000b
SYMBTYPE   EQU  00100000b
EXTRTYPE   EQU  10000000b


IFDEF   ??version       ; Only defined with TASM
LOCALS                  ; Enable Local Labels
ENDIF                   ; NOTE: Local labels are default with MASM (6.00) if a
                        ;       language specifier is used with the .MODEL
                        ;       statement


;[]------------------[ MACRO TO PUSH MULTIPLE REGISTERS ]--------------------[]
;|  MACRO to simplify pushing of multiple registers... If 80188 (and above)   |
;|  Code generation is enabled, immediates can also be pushed...              |
;[]--------------------------------------------------------------------------[]
@PUSH   MACRO   a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15
        IFNB   <a0>
        push    a0
        @PUSH   a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15
        ENDIF
        ENDM


;[]-----------------[ MACRO FOR POPPING MULTIPLE REGISTERS ]-----------------[]
;|  MACRO to simplify popping of multiple registers... Up to sixteen registers|
;|  can be popped.... Complements @PUSH MACRO...                              |
;[]--------------------------------------------------------------------------[]
@POP    MACRO   a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15
        IFNB   <a0>
        @POP    a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15
        pop     a0
        ENDIF
        ENDM


;[]-----------------[ GENERIC ERROR HANDLING MACRO ]-------------------------[]
;|  MACRO to display an error message - Used from other MACROS usually ...    |
;[]--------------------------------------------------------------------------[]
@Error  MACRO   ErrMsg
       .ERR                                     ; Forces an Error
        %out  **Error**: &ErrMsg                ; Display Error Message
        ENDM
