{//////////////////////////////////////////////////////////////////////////////}
{ This an example UNIT showing how to use the E! API interrupt routines.       }
{ This file may be compiled using Turbo Pascal 4.0/5.0                         }
{ C programmers will easily convert it to both API.H and API.C files           }
{//////////////////////////////////////////////////////////////////////////////}
{$A-,B-,D+,E+,F-,I-,L+,N-,R-,S-,V-}

UNIT API;

INTERFACE

USES DOS;

TYPE

 { These are the declarations of useful Records allowing you to retrieve }
 { more easily E! variables values.                                      }

 FlagRecord = RECORD
               AddOnLast      : boolean; { Key down insert newline on last line flag }
               AlarmFlag      : boolean; { Error beep flag                      }
               AsciiMode      : boolean; { Control characters entry flag        }
               AutoBackFlag   : boolean; { Backspace behaviour flag             }
               AutoSaveFlag   : boolean; { Autosave flag                        }
               AutoScrollFlag : boolean; { Autoscroll flag                      }
               AutoTabFlag    : boolean; { Autotab flag                         }
               BakFlag        : boolean; { .BAK files generation flag           }
               BlanksFlag     : boolean; { Strip trailing spaces when saving flag}
               CompFlag       : boolean; { Compression mode flag                }
               Ega_Vga_OK     : boolean; { 43 lines mode flag                   }
               Flag35         : boolean; { 35 lines mode flag - EGA_VGA_OK must be on}
               LogFlag        : boolean; { Log file flag                        }
               PauseMode      : boolean; { Pause on return from DOS flag        }
               ShiftFlag      : boolean; { Accelerated cursor flag              }
               Warning        : boolean; { Warning before saving flag           }
               Enter_Classic  : boolean; { Split line using ENTER flag          }
               Refresh        : boolean; { Autorisation d'affichage             }
              END;

 AttrRecord = RECORD
               Text_Attr        : byte;  { Edited text attribute   }
               BlockAttr        : byte;  { Marked block attribute  }
               CommandLineAttr  : byte;  { Command line attribute  }
               LoStatusLineAttr : byte;  { Status line 1 attribute }
               HiStatusLineAttr : byte;  { Status line 2 attribute }
               MessageAttr      : byte;  { Messages attribute      }
               HelpAttr         : byte;  { Help line attribute     }
               CursorAttr       : byte;  { Virtual cursor attribute}
              END;

 MargRecord = RECORD
                ShiftKeyCount   : word;   { Delay value for secondary help lines }
                AutoSaveLimit   : word;   { Keystrokes# for autosave             }
                ScrollAmountGlb : integer;{ Left / Right scroll amount           }
                DrawModel       : integer;{ Drawing style                        }
                LeftMargin      : integer;{ Left margin                          }
                ParMargin       : integer;{ New paragraph margin                 }
                RightMargin     : integer;{ Right margin                         }
              END;

 MessageRecord = RECORD
                  HelpLine          : array[1..4] of string[80];
                    { Help line and 3 secondary help lines }
                  EditErrorMessages : array[1..43] of string[43];
                    { Error messages --> 38 for the english version}
                 END;

 StatusRecord =  RECORD
                  linenum,            { Line number of current text    }
                  line    : word;     { Current row in current text    }
                  col,                { Current column in current text }
                  firstcol,           { First displayed column         }
                  lower,              { Displayed lines number         }
                  nbwin   : byte;     { Number of windows              }
                 END;

textline   = string;                  { Each line has 255 char. max.       }
lineptr    = ^textline;               { Textflow points to a pointers ar-  }
textflowar = array [0..1] of lineptr; { ray (1 to linenum - see above).    }
textflow   = ^textflowar;             { Each pointer points to a text line.}

commandline = string[80];

CONST

   E_Vec : byte = $C0; { No de l'interruption utilise par E!  }

   { This value may be changed if it conflicts with an already used  }
   { interrupt vector. In this case E!.EXE must be patched to reflect}
   { that change. See E! API USER's GUIDE }

   { Values to pass in AH to specify the E! API service you want to use }
   FUNCTION_REQUEST   = 0;   { Call a E! function - code in BX }

   EDITBUFF_REQUEST   = 1;   { Request Editbuffer address              }
   FLAGS_REQUEST      = 2;   { Request flags block address             }
   ATTR_REQUEST       = 3;   { Request attribute block address         }
   MARG_REQUEST       = 4;   { Request margins+misc. block address     }
   MESS_REQUEST       = 5;   { Request messages block address          }
   FLOW_REQUEST       = 6;   { Request pointers array address-text flow}
   NAME_REQUEST       = 7;   { Request current name address            }

   STATUS_REQUEST     = 8;   { Request curr.line, line#, column etc... }

   DISPLINE_SERVICE   = 9;   { Display contents of edit buffer }
   REFRESH_SERVICE    = 10;  { Rebuild the whole E! screeen    }
   MASK_SERVICE       = 11;  { Refresh text mask               }
   STORE_SERVICE      = 12;  { Store edit Buffer to text       }
   CHANGE_SERVICE     = 13;  { Set change flag to true         }

   SEEK_SERVICE       = 14;  { Set active line                 }

   VERSION_SERVICE    = 15;  { Return version number }

   REGISTER_SERVICE   = 16;  { Execute command after exit}

   { If AH is set to 0 please use one of the following function code }
   { and pass it to E! API thru BX.                                  }

   ALIGN_TEXT         = 001; { Align text to cursor                   }
   PASCAL_STYLE       = 002; { See documentation (Ctrl B)             }
   CLEAR_LINE         = 003; { Clear line                             }
   REPEAT_CHAR        = 004; { Repeat specified character             }
   CLEAR_EOL          = 005; { Erase end of line                      }
   WRAP               = 006; { Toggle Wordwrap                        }
   _43LINES           = 007; { Toggle 35/43/50 lines mode             }
   DELETE_LEFT        = 008; { Delete left character                  }
   NEXT_TAB           = 009; { Go to next tab                         }
   JUSTIFICATION      = 010; { Toggle justify mode                    }
   EDIT               = 012; { Edit a file                            }
   ENTER              = 013; { Insert a line or validate a command    }
   INSERT_NAME        = 014; { Insert filename                        }
   MACRO              = 016; { Execute active macro                   }
   RESTORE_MACRO      = 017; { Restore previous macro                 }
   REPEAT_SEARCH      = 019; { Repeat last search                     }
   INSERT_DATE        = 020; { Insert date and time                   }
   INIT_SEARCH        = 022; { Initialize search variables            }
   DEL_WORD           = 023; { Delet current word                     }
   EXECUTE            = 024; { Execute current line as a command      }
   LIST_DIR           = 026; { List current line as a directory       }
   CHANGE_MODE        = 027; { Toggle between editmode and commandmode}
   REMOVE_LINE        = 127; { Remove current line                    }
   PREV_TAB           = 271; { Go to previous tab                     }
   CONTINUE           = 272; { Insert a continue-mark in macro        }
   END_OF_BLOCK       = 274; { Go to end of block                     }
   REMOVE_TAB         = 275; { Remove current tab position            }
   RECORD_TAB         = 276; { Create a new tab positioneur           }
   BLOCK_BEGIN        = 277; { Go to block begin                      }
   UNMARK             = 278; { Unmark block                           }
   REMOVE_TABS        = 279; { Remove all tab positions               }
   OVERLAY            = 280; { Overlay block at cursor position       }
   PARAGRAPH          = 281; { Go to next paragraph                   }
   ADJUST             = 286; { Adjust block position                  }
   SPLIT              = 287; { Split line at cursor                   }
   DELETE_BLOCK       = 288; { Delete marked block                    }
   FILL_BLOCK         = 289; { Fill block with specified character    }
   SORT               = 290; { Sort block                             }
   BOX                = 291; { Draw a box around the block            }
   JOIN               = 292; { Join current line and next line        }
   BOOKMARK           = 293; { Drop bookmark                          }
   LINE_MARK          = 294; { Mark lines                             }
   SENTENCE_MARK      = 300; { Mark sentences                         }
   GRAPHICS           = 301; { Toggle control characters access       }
   COPY_BLOCK         = 302; { Copy block to cursor position          }
   REMOVE_SPACES      = 303; { Remove trailing blanks                 }
   BLOCK_MARK         = 304; { Mark block                             }
   MOVE_BLOCK         = 306; { Move block                             }
   HELP               = 315; { Load help file                         }
   SAVE               = 316; { Save current file                      }
   QUIT               = 317; { Quit current file                      }
   QUIT_SAVE          = 318; { Quite and save current file            }
   WINDOW             = 319; { Create/Remove window                   }
   DRAW               = 320; { Toggle draw mode                       }
   NAME               = 321; { Name current file                      }
   LOAD               = 322; { Edit a new file                        }
   RESTORE            = 323; { Restore (undo) current line            }
   NEXT               = 324; { Go to next file                        }
   LINE_BEGIN         = 327; { Go to line begin                       }
   UP                 = 328; { Up                                     }
   PREV_PAGE          = 329; { Scroll screen up                       }
   LEFT               = 331; { Left                                   }
   RIGHT              = 333; { Right                                  }
   EOL                = 335; { Go to end of line                      }
   DOWN               = 336; { Down                                   }
   NEXT_PAGE          = 337; { Scroll screen down                     }
   TOGGLE_INSERT      = 338; { Toggle insert mode                     }
   DEL_CHAR           = 339; { Delete character at cursor             }
   SCROLL_RIGHT       = 340; { Scroll right                           }
   SCROLL_LEFT        = 341; { Scroll left                            }
   SCROLL_UP          = 342; { Scroll up                              }
   SCROLL_DOWN        = 343; { Scroll down                            }
   CENTER_LINE        = 344; { Center line in window                  }
   RAISE_LINE         = 345; { Raise line to top of window            }
   UPCASE_WORD        = 350; { Upcase word                            }
   LOWCASE_WORD       = 351; { Lowcase word                           }
   UPCASE_BLOCK       = 352; { Upcase block                           }
   LOWCASE_BLOCK      = 353; { Lowcase block                          }
   CENTER_BLOCK       = 354; { Center text in block                   }
   FORMAT_PAR         = 355; { Format paragraph                       }
   FORMAT_BLOCK       = 356; { Format paragraphs within block         }
   KEYHELP            = 360; { Key oriented help                      }
   PAGE_RIGHT         = 362; { Scroll page right                      }
   PAGE_LEFT          = 363; { Scroll page left                       }
   CHANGE_WINDOW      = 364; { Change active window                   }
   DELETE_WINDOW      = 365; { Supprime une fentre                   }
   FULL_SCREEN        = 366; { Supprime les fentres                  }
   NEXT_ERROR         = 367; { Go to next compilation error           }
   PREV_ERROR         = 368; { Go to previous compilation error       }
   PREVIOUS           = 369; { Go to previous file                    }
   PREV_WORD          = 371; { Go to previous word                    }
   NEXT_WORD          = 372; { Go to next word                        }
   TEXT_END           = 373; { Go to end of text                      }
   PAGE_BOTTOM        = 374; { Go to bottom of window                 }
   TEXT_BEGIN         = 375; { Go to text begin                       }
   TEXTMARK1          = 376; { Drop text mark 1                       }
   TEXTMARK2          = 377; { Drop text mark 2                       }
   TEXTMARK3          = 378; { Drop text mark 3                       }
   UNMARK_TEXTS       = 379; { Remove text marks                      }
   REFRESH            = 380; { Reload (refresh) original file         }
   PAIRED_BRACE       = 381; { See documentation                      }
   MATCH_BRACE        = 382; { See documentation                      }
   UNDO               = 383; { Restore removed lines                  }
   INSERT_DOS         = 384; { Insert captured lines (DOS SHELL)      }
   SEARCH_WORD        = 385; { Search current word                    }
   INSERT_BLOCK       = 386; { Insert blanks before block             }
   INSERT_BLANK       = 387; { Insert blanks without moving cursor    }
   PAGE_TOP           = 388; { Go to top of window                    }

CALLFAILED = $FF;
{ A bad function id has been passed to Call_E_Function }



Function  Call_E_Function(funcno : word) : byte;
 { Use this function to execute a E! function }

Function  Request_E_Address(request_name : byte) : pointer;
 { Use this function to get the address of E! variables }

Procedure Get_E_Status(VAR status : statusrecord);
 { Use this function to get cursor current position and window status }

Procedure Request_E_Service(service : byte);
 { Use this function to get special services }

Procedure Get_E_Version(VAR major, minor : byte);
 { Retrieve E! version }

Procedure RegisterCommand(commandstr : commandline);
 { Execute a E! command after exit}

Function Seek_E_Line(line : word; curpos : byte):byte;
{ Call E! seek function and return error code }

IMPLEMENTATION

Function Call_E_Function(funcno : word):byte;
{ Call E! function #funcno and return error code }
{ Example : retcode:=Call_E_Function(Page_Top)   }

VAR  regs : registers;

BEGIN
 regs.AH:=0;
 regs.BX:=funcno;
 Intr(E_Vec, regs);
 Call_E_Function:=regs.AL;
END;

Function Request_E_Address(request_name : byte):pointer;
{ Returns a pointer to the requested variables block }

VAR  regs : registers;

BEGIN
 IF NOT request_name IN [1..7] THEN Exit;
 regs.AH:=request_name;
 Intr(E_Vec, regs);
 Request_E_Address:=Ptr(regs.ES, regs.BX);
END;

Procedure Get_E_Status(VAR status : statusrecord);
{ Loads status members with appropriate values }

VAR  regs : registers;

BEGIN
 regs.AH:=STATUS_REQUEST;
 Intr(E_Vec, regs);
 WITH status DO
 BEGIN
  linenum :=regs.CX;
  line    :=regs.DX;
  col     :=regs.AH;
  firstcol:=regs.AL;
  lower   :=regs.BH;
  nbwin   :=regs.BL;
 END;
END;

Procedure Request_E_Service(service:byte);

VAR  regs : registers;

BEGIN
 regs.AH:=service;
 Intr(E_Vec, regs);
END;

Procedure Get_E_Version(VAR major, minor : byte);

VAR  regs : registers;

BEGIN
 regs.AH:=VERSION_SERVICE;
 Intr(E_Vec, regs);
 major:=regs.AH;
 minor:=regs.AL;
END;

Procedure RegisterCommand(commandstr : commandline);

VAR  regs : registers;

BEGIN
 regs.AH:=REGISTER_SERVICE;
 regs.ES:=Seg(commandstr);
 regs.BX:=Ofs(commandstr);
 Intr(E_Vec, regs);
END;

Function Seek_E_Line(line : word; curpos : byte):byte;
{ Call E! seek function and return error code }

VAR  regs : registers;

BEGIN
 regs.AH:=14;
 regs.BX:=line;
 regs.AL:=curpos;
 Intr(E_Vec, regs);
 Seek_E_Line:=regs.AL;
END;

END.
