PAGE 60, 132
NAME	pseudo_overlay_module

;-----------------------------------------------------------------------------;
;   Placing null segment declarations at this point forces the segment        ;
;   order for the remainder of the program.                                   ;
;-----------------------------------------------------------------------------;

CODE	SEGMENT PARA PUBLIC 'CODE'
ORG	100h
CODE	ENDS

DATA	SEGMENT PARA PUBLIC 'DATA'
DATA	ENDS


PAGE
;-----------------------------------------------------------------------------;
;                     E Q U A T E S   &   M A C R O S                         ;
;-----------------------------------------------------------------------------;
cr	EQU	0Dh
lf	EQU	0Ah

DISPLAY	MACRO		msg
	MOV		AH, 09h
	LEA		DX, msg
	INT		21h
ENDM


PAGE
;-----------------------------------------------------------------------------;
;         C O D E   S E G M E N T    F O R   T H E   O V E R L A Y            ;
;-----------------------------------------------------------------------------;

CODE	SEGMENT PARA PUBLIC 'CODE'

ASSUME CS:CODE, DS:DATA

;-----------------------------------------------------------------------------;
;   We will establish a convention in which the first object located at the   ;
;   expanded memory page frame will be a data structure which describes       ;
;   the data & extra segments of the loaded overlay, the number of procedure  ;
;   entry points in the loaded overlay, and a list of far pointers to         ;
;   each of the procedures contained in the pseudo-overlay which is to be     ;
;   loaded in expanded memory.  The developer must establish a convention     ;
;   for the sequence of the far pointers and what the procedures they point   ;
;   to do.  Other information could be passed in this structure as well.      ;
;   Such as, number and types of parameters which are be passed by the        ;
;   calling procedures to the called procedures in the pseudo-overlay.        ;
;                                                                             ;
;   This example uses a literal to determine the actual number of far         ;
;   pointers which are passed.  To allocate additional space for a larger     ;
;   number of entries, simply increase the value of actual_proc_entries.      ;
;   The example assumes an actual count of 2 entries will be returned.        ;
;-----------------------------------------------------------------------------;

actual_proc_entries		EQU	2

overlay_entry_struct		STRUC
	proc_data_segment	DW	?
	proc_extra_segment	DW	?
	proc_entry_count	DW	?
	proc_entry_ptr		DD actual_proc_entries DUP (?)
overlay_entry_struct		ENDS


PAGE
;-----------------------------------------------------------------------------;
;         C O D E   S E G M E N T    F O R   T H E   O V E R L A Y            ;
;-----------------------------------------------------------------------------;

initialization	PROC	FAR

	MOV	AX, DATA					;   Set up local data segment
	MOV	DS, AX

	MOV	AH, 41h						;   Get the page frame segment
	INT	67h						; address from EMM
	OR	AH, AH
	JNZ	error_exit

	MOV	ES, BX						; Create a pointer to the expanded memory 
	MOV	DI, 0						; page frame segment address

	MOV	ES:[DI].proc_data_segment, DS			; Return local data & extra segement back to kernal
	MOV	ES:[DI].proc_extra_segment, DS

	MOV	WORD PTR ES:[DI].proc_entry_count, 2		; Return number of local callable
								; procedures back to kernal

	MOV	WORD PTR ES:[DI].proc_entry_ptr[0], OFFSET sum	; Return a far pointer to each
	MOV	WORD PTR ES:[DI].proc_entry_ptr[2], SEG    sum	; local callable procedure in
	MOV	WORD PTR ES:[DI].proc_entry_ptr[4], OFFSET diff	; the pseudo-overlay back to kernal
	MOV	WORD PTR ES:[DI].proc_entry_ptr[6], SEG    diff

exit:

	MOV	AH, 0						; Set status in AH = passed

error_exit:

	RET							; Return status in AH


initialization	ENDP


PAGE
;-----------------------------------------------------------------------------;
;   This procedure merely informs a user that this is an overlay and cannot   ;
;   be executed from the command line.                                        ;
;-----------------------------------------------------------------------------;

command_line_entry_point	PROC	NEAR

	;---------------------------------------------------------------------;
	;   Initialization                                                    ;
	;---------------------------------------------------------------------;
	MOV	AX, DATA
	MOV	DS, AX

	;---------------------------------------------------------------------;
	;   Indicate to the user that the overlay cannot be executed from     ;
	;   The command line.                                                 ;
	;---------------------------------------------------------------------;
	DISPLAY	overlay_err_msg

	;---------------------------------------------------------------------;
	;   Exit to DOS command line.                                         ;
	;---------------------------------------------------------------------;
	MOV	AX, 4C00h
	INT	21h

command_line_entry_point	ENDP


PAGE
;-----------------------------------------------------------------------------;
;   This procedure simpy adds the numbers in AX & DX and displays them.       ;
;-----------------------------------------------------------------------------;

sum	PROC	FAR

	;---------------------------------------------------------------------;
	;   Simple minded procedure to add two numbers passed to it.          ;
	;---------------------------------------------------------------------;
	ADD		AX, DX

	;---------------------------------------------------------------------;
	;   Display the results.                                              ;
	;---------------------------------------------------------------------;
	PUSH		AX
	DISPLAY		sum_msg
	POP		AX
	CALL		display_result
	DISPLAY		cr_lf_msg

	;---------------------------------------------------------------------;
	;   Return to the caller.                                             ;
	;---------------------------------------------------------------------;
	RET

sum	ENDP


;-----------------------------------------------------------------------------;
;   This procedure simply subtracts the numbers in AX & DX and displays them. ;
;-----------------------------------------------------------------------------;

diff	PROC	FAR

	;---------------------------------------------------------------------;
	;   Simple minded procedure to subtract two numbers passed to it.     ;
	;---------------------------------------------------------------------;
	SUB		AX, DX

	;---------------------------------------------------------------------;
	;   Display the results.                                              ;
	;---------------------------------------------------------------------;
	PUSH		AX
	DISPLAY		diff_msg
	POP		AX
	CALL		display_result
	DISPLAY		cr_lf_msg

	;---------------------------------------------------------------------;
	;   Return to the caller.                                             ;
	;---------------------------------------------------------------------;
	RET						; Return to caller

diff	ENDP


;-----------------------------------------------------------------------------;
;   Procedure to display the number in AX in decimal.                         ;
;-----------------------------------------------------------------------------;

display_result	PROC	NEAR

	LEA		DI, powers_of_ten
	MOV		CX, 5

display_loop:

	XOR		DX, DX				; Divide the number passed
	DIV		WORD PTR [DI]			; in AX by descending powers of ten
	ADD		AL, '0'				; Convert digit to ASCII

	PUSH		DX				; Output the digit
	MOV		DL, AL
	MOV		AH, 02h
	INT		21h
	POP		AX

	ADD		DI, 2
	LOOP		display_loop

	RET

display_result	ENDP


PAGE

CODE	ENDS


PAGE
;-----------------------------------------------------------------------------;
;         D A T A   S E G M E N T    F O R   T H E   O V E R L A Y            ;
;-----------------------------------------------------------------------------;

DATA	SEGMENT PARA PUBLIC 'DATA'

	executing_overlay_msg	DB	'.  .  Excuting code in expanded memory', cr, lf, '$'
	sum_msg			DB	'.  .  Executing sum of numbers proc in expanded memory', cr, lf
				DB	'.  .     SUM = $'
	diff_msg		DB	'.  .  Executing difference of numbers proc in expanded memory', cr, lf
				DB	'.  .     DIFFERENCE = $'
	overlay_err_msg		DB	'Overlay cannot be executed via the command line$'
	cr_lf_msg			DB	cr, lf, '$'

	powers_of_ten	DW	10000, 1000, 100, 10, 1

DATA ENDS

END	command_line_entry_point
