;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_F.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   alloc_DMA_reg_set                                       ;
;                                                                             ;
;      DESCRIPTION:   This function gets the number of a DMA register set     ;
;                     for an OS/E, if a DMA register set is currently         ;
;                     available for use.                                      ;
;                                                                             ;
;                     In a multitasking operating system, when one task is    ;
;                     waiting for DMA to complete, it is useful to be able to ;
;                     switch to another task.  However, if the DMA is being   ;
;                     mapped through the current register set, the switching  ;
;                     cannot occur.  That is, all DMA action must be complete ;
;                     before any remapping of pages can be done.              ;
;                                                                             ;
;                     The operating system would initiate a DMA operation on  ;
;                     a specific DMA channel using a specific alternate map   ;
;                     register set.  This alternate map register set would    ;
;                     not be used again, by the operating system or an        ;
;                     application, until after the DMA operation is complete. ;
;                     The operating system guarantees this by not changing    ;
;                     the contents of the alternate map register set, or      ;
;                     allowing an application to change the contents of the   ;
;                     alternate map register set, for the duration of the DMA ;
;                     operation.                                              ;
;                                                                             ;
;           PASSED:   &DMA_reg_set:                                           ;
;                        is a far pointer to the DMA register set parameter.  ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     DMA_reg_set:                                            ;
;                        is the DMA register set number.  If there are no DMA ;
;                        register sets supported by the hardware, a zero will ;
;                        be returned.                                         ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int DMA_reg_set;                               ;
;                                                                             ;
;                     status = alloc_DMA_reg_set (&DMA_reg_set);              ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alloc_DMA_reg_set	PROC                                                  \
			ptr_DMA_reg_set:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   allocate a DMA register set for use by the OS;                ;
	;---------------------------------------------------------------------;
	MOVE		AX, allocate_dma_reg_set_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the DMA register set back to the OS;                     ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:BL
	MOVE		ES:BX, ptr_DMA_reg_set
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alloc_DMA_reg_set		ENDP

END
