;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_D.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   alloc_alt_reg_set                                       ;
;                                                                             ;
;      DESCRIPTION:   This function gets the number of an alternate map       ;
;                     register set for an operating system if an alternate    ;
;                     map register set is currently available for use.  If    ;
;                     the hardware does not support alternate map register    ;
;                     sets, an alternate map register set number of zero will ;
;                     be returned.                                            ;
;                                                                             ;
;                     The alternate map register set allocated may be         ;
;                     referred to by this number when using the               ;
;                     get_alt_reg_set or set_alt_reg_set functions.  The      ;
;                     operating system can use these functions to switch map  ;
;                     contexts very rapidly on expanded memory hardware with  ;
;                     alternate map register sets.  This function copies the  ;
;                     currently active alternate map register sets contents   ;
;                     into the newly allocated alternate map register set's   ;
;                     mapping registers.  This is done so that when the OS/E  ;
;                     performs a set_alt_reg_set function the memory mapped   ;
;                     before the allocation of the new alternate map will be  ;
;                     available for reading and writing.  This function does  ;
;                     not actually change the alternate map register set in   ;
;                     use, but in addition to allocating a new alternate map  ;
;                     register set, it prepares the new alternate map         ;
;                     register set for a subsequent set_alt_reg_set function. ;
;                                                                             ;
;           PASSED:   &alt_reg_set:                                           ;
;                        is a far pointer to the alternate register set       ;
;                        which will be allocated to the operating system.     ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     alt_reg_set:                                            ;
;                        is the number of an alternate map register set.  If  ;
;                        there are no alternate map register sets supported   ;
;                        by the hardware, a zero will be returned.  In this   ;
;                        case, the get_alt_reg_set function should be invoked ;
;                        in order to obtain a pointer to a mapping hardware   ;
;                        context save area.  The OS/E must supply this save   ;
;                        area.  The save area is necessary because the        ;
;                        hardware doesn't support alternate map register      ;
;                        sets.                                                ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int alt_reg_set;                               ;
;                                                                             ;
;                     status = alloc_alt_reg_set (&alt_reg_set);              ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alloc_alt_reg_set	PROC	                                              \
			ptr_alt_reg_set:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   allocate an alternate map register set from EMM;              ;
	;---------------------------------------------------------------------;
	MOVE		AX, allocate_alt_map_regs_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the alternate map register set back to the caller;       ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:BL
	MOVE		ES:BX, ptr_alt_reg_set
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alloc_alt_reg_set		ENDP

END
