;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM27_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   alloc_raw_pages                                         ;
;                                                                             ;
;                     The alloc_raw_pages function allocates the number of    ;
;                     non-standard size pages that the operating system       ;
;                     requests and assigns a unique EMM handle to these       ;
;                     pages.  The EMM handle owns these pages until the       ;
;                     operating system deallocates them.                      ;
;                                                                             ;
;                     This function allows you to allocate zero pages to a    ;
;                     handle, unlike the alloc_pages function.                ;
;                                                                             ;
;                     A hardware vendor may design an expanded memory board   ;
;                     that has a page size which is a sub-multiple of 16K     ;
;                     bytes.  A physical page which is a sub-multiple of 16K  ;
;                     is termed a raw page.  The operating system may deal    ;
;                     with page sizes which are sub-multiples of 16K bytes.   ;
;                     The memory manager must treat any function using a      ;
;                     handle with raw pages allocated to it by                ;
;                     alloc_raw_pages differently than it does a handle that  ;
;                     has normal 16K-byte pages allocated to it.              ;
;                                                                             ;
;                     Handles which are assigned using alloc_pages or         ;
;                     alloc_std_pages must have pages which are 16K bytes --  ;
;                     this is the length of a standard expanded memory page.  ;
;                     If the expanded memory board hardware is not able to    ;
;                     supply 16K-byte pages, the memory manager must emulate  ;
;                     pages which are 16K bytes combining multiple            ;
;                     non-standard size pages to form a single 16K-byte page. ;
;                     Handles which are assigned using alloc_raw_pages are    ;
;                     called raw handles.  All logical pages allocated to a   ;
;                     raw handle may have a non-standard length (that is, not ;
;                     16K bytes).  However, once the operating system has     ;
;                     allocated a number of raw pages to a handle, it is the  ;
;                     responsibility of the memory manager to recognize that  ;
;                     raw handle as one that has non-standard size pages      ;
;                     allocated to it.  The memory manager must identify      ;
;                     these handles and treat all functions which use handles ;
;                     which have non-standard page lengths differently.  The  ;
;                     logical page length becomes the length of the           ;
;                     non-standard size page for any raw handle that          ;
;                     alloc_raw_pages assigns.                                ;
;                                                                             ;
;                     Note:                                                   ;
;                        This note affects expanded memory manager            ;
;                        implementers and operating system developers only.   ;
;                        Applications should not use the following            ;
;                        characteristic of the memory manager.  An            ;
;                        application violating this rule will be incompatible ;
;                        with future versions of Microsoft's operating        ;
;                        systems and environments.                            ;
;                                                                             ;
;                        To be compatible with this specification, an         ;
;                        expanded memory manager will provide a special       ;
;                        handle which is available to the operating system    ;
;                        only.  This handle will have a value of 0 and        ;
;                        will have a set of pages allocated to it when the    ;
;                        expanded memory manager driver installs.  The pages  ;
;                        that the memory manager will automatically allocate  ;
;                        to handle 0 are those that it has mapped into        ;
;                        conventional memory.                                 ;
;                                                                             ;
;                        An operating system won't have to invoke the         ;
;                        alloc_raw_pages function to obtain this handle       ;
;                        because it can assume the handle already exists and  ;
;                        is available for use immediately after the expanded  ;
;                        memory device driver installs.  When an operating    ;
;                        system wants to use this handle, it uses the special ;
;                        handle value of 0. The operating system will be able ;
;                        to invoke any EMM function using this special handle ;
;                        value.  To allocate pages to this handle, the        ;
;                        operating system need only invoke realloc_pages      ;
;                        function.                                            ;
;                                                                             ;
;                        There are two special cases for this handle:         ;
;                        1. alloc_raw_pages: when invoked, must never return  ;
;                           zero as a handle value.  Applications must always ;
;                           invoke alloc_std_pages to allocate pages and      ;
;                           obtain a handle which identifies the pages which  ;
;                           belong to it.  Since alloc_std_pages never        ;
;                           returns a handle value of zero, an application    ;
;                           will never gain access to this special handle.    ;
;                                                                             ;
;                        2. dealloc_pages: if the operating system uses it to ;
;                           deallocate the pages which are allocated to this  ;
;                           handle, the pages the handle owns will be         ;
;                           returned to the manager for use.  But the handle  ;
;                           will not be available for reassignment.  The      ;
;                           manager should treat a deallocate pages function  ;
;                           request for this handle the same as a reallocate  ;
;                           pages function request, where the number of pages ;
;                           to reallocate to this handle is zero.             ;
;                                                                             ;
;           PASSED:   raw_page_count:                                         ;
;                        is the number of raw pages the operating system      ;
;                        wants to allocate.                                   ;
;                                                                             ;
;                     &handle:                                                ;
;                        is a far pointer to a unique handle which the memory ;
;                        manager will assign to the block of pages allocated  ;
;                        to the operating system.                             ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle:                                                 ;
;                        is a unique handle which the memory manager will     ;
;                        assign to the block of pages allocated to the        ;
;                        operating system.  The operating system must use     ;
;                        this EMM handle as a parameter in any function that  ;
;                        requires it.  Up to 255 handles may be obtained.     ;
;                        The alloc_pages and alloc_raw_pages functions must   ;
;                        share the same 255 handles.                          ;
;                                                                             ;
;                        For all functions using this raw handle, the length  ;
;                        of the physical and logical pages allocated to it    ;
;                        may be non-standard (that is, not 16K bytes).        ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int raw_page_count;                            ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = alloc_raw_pages (raw_page_count,               ;
;                                               &handle);                     ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alloc_raw_pages		PROC	                                              \
			raw_page_count:WORD,                                  \
			ptr_handle:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   allocate the number of specified RAW pages from EMM;          ;
	;---------------------------------------------------------------------;
	MOVE		AX, alloc_raw_pages_fcn
	MOVE		BX, raw_page_count
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the handle back to the caller;                           ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alloc_raw_pages		ENDP

END
