;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM23_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   alter_map_call                                          ;
;                                                                             ;
;      DESCRIPTION:   This function saves the current memory mapping context, ;
;                     alters the specified memory mapping context, and        ;
;                     transfers control to the specified address.  It is      ;
;                     analogous to the FAR CALL in the 8086 family            ;
;                     architecture.  Just as a return from a FAR CALL         ;
;                     restores the original value in the code segment         ;
;                     register, this function restores the state of the       ;
;                     specified mapping context after the return.             ;
;                                                                             ;
;                     There is no explicit expanded memory function which     ;
;                     emulates a return from a FAR CALL.  However, this       ;
;                     facility is implicitly available through the standard   ;
;                     return from a FAR CALL.  The following paragraphs       ;
;                     describe how this works:                                ;
;                                                                             ;
;                     After this function is invoked, unless an error is      ;
;                     detected, the memory manager will transfer control to   ;
;                     the address specified.  If an error occurs, the memory  ;
;                     manager returns immediately with the error status.      ;
;                     Otherwise, the memory manager pushes on the stack       ;
;                     information which enables it to restore the mapping     ;
;                     context after the return.                               ;
;                                                                             ;
;                     When the called procedure wants to return to the        ;
;                     calling procedure, it simply issues a standard FAR      ;
;                     RETURN.  The memory manager traps this return, restores ;
;                     the specified mapping context, and returns to the       ;
;                     calling procedure.  The memory manager also returns a   ;
;                     status from a successful return just as it does for all ;
;                     functions.                                              ;
;                                                                             ;
;                     Developers using this function must make allowances for ;
;                     the additional stack space this function will use.      ;
;                                                                             ;
;           PASSED:   mode:                                                   ;
;                        is a flag which indicates whether the value          ;
;                        contained in the init_map.phys_page_or_seg &         ;
;                        final_map.phys_page_or_seg structure members are a   ;
;                        physical page number or the segment address          ;
;                        representation of the physical page numbers.  A zero ;
;                        indicates that the values are physical page numbers. ;
;                        A one indicates that the values in these members     ;
;                        are the segment address representations of the       ;
;                        physical page numbers.                               ;
;                                                                             ;
;                                                                             ;
;                     &mc:                                                    ;
;                        is a far pointer to a structure which contains the   ;
;                        information necessary to map the desired physical    ;
;                        pages and call the target address.                   ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        mc.target_function:                                  ;
;                           is a far pointer which contains the target        ;
;                           address to which control is to be transferred.    ;
;                           The application must supply this is value.        ;
;                                                                             ;
;                        mc.init_map_struct_count:                            ;
;                           is the number of entries in the initial mapping   ;
;                           context to which mc.ptr_init_map_struct points.   ;
;                           This number cannot exceed the number of mappable  ;
;                           pages in the system.                              ;
;                                                                             ;
;                        mc.ptr_init_map_struct:                              ;
;                           is a far pointer to an array of structures which  ;
;                           contains a list of the logical page numbers and   ;
;                           the physical page numbers/segments at which they  ;
;                           are to be mapped immediately BEFORE the call.     ;
;                           The init_map array of structures is described at  ;
;                           the end of the mc structure.                      ;
;                                                                             ;
;                        mc.final_map_struct_count:                           ;
;                           is the number of entries in the final mapping     ;
;                           context to which mc.ptr_final_map_struct points.  ;
;                           This number cannot exceed the number of mappable  ;
;                           pages in the system.                              ;
;                                                                             ;
;                        mc.ptr_final_map_struct:                             ;
;                           is a far pointer to an array of structures which  ;
;                           contains a list of the logical page numbers and   ;
;                           the physical page numbers/segments at which they  ;
;                           are to be mapped immediately AFTER the return.    ;
;                           The final_map array of structures is described    ;
;                           at the end of the mc structure.                   ;
;                                                                             ;
;                        mc.reserved:                                         ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.                               ;
;                                                                             ;
;                     init_map                                                ;
;                     & final_map:                                            ;
;                        are arrays of structures which contain lists of the  ;
;                        logical page numbers and the physical page           ;
;                        numbers/segments at which they are to be mapped.     ;
;                        The init_map array of structures specifies the       ;
;                        mapping immediately BEFORE the CALL.  The final_map  ;
;                        array of structures specifies the mapping            ;
;                        immediately AFTER the RETURN.                        ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        init_map.log_page                                    ;
;                        & final_map.log_page:                                ;
;                           is the logical page to be mapped.                 ;
;                                                                             ;
;                        init_map.phys_page_or_seg                            ;
;                        & final_map.phys_page_or_seg:                        ;
;                           is either the physical page number or the         ;
;                           segment address representation of the physical    ;
;                           page number at which the previous logical page    ;
;                           number is to be mapped.  The mode passed          ;
;                           determines the type of representation.            ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int    status;                                 ;
;                     unsigned int    mode;                                   ;
;                     unsigned int    handle;                                 ;
;                     MAP_STRUCT      init_map [MAX_MAPPABLE_REGIONS];        ;
;                     MAP_STRUCT      final_map [MAX_MAPPABLE_REGIONS];       ;
;                     MAP_CALL_STRUCT mc;                                     ;
;                                                                             ;
;                     init_map[0].log_page          = 0;                      ;
;                     init_map[0].phys_page_or_seg  = 0xC000;                 ;
;                                                                             ;
;                     final_map[0].log_page         = 1;                      ;
;                     final_map[0].phys_page_or_seg = 0xC000;                 ;
;                     final_map[1].log_page         = 2;                      ;
;                     final_map[1].phys_page_or_seg = 0xC400;                 ;
;                                                                             ;
;                     mode = SEG_MODE;                                        ;
;                     mc.target_function        = 0xC0000000;                 ;
;                     mc.init_map_struct_count  = 1;                          ;
;                     mc.ptr_init_map_struct    = init_map;                   ;
;                     mc.final_map_struct_count = 2;                          ;
;                     mc.ptr_final_map_struct   = final_map;                  ;
;                                                                             ;
;                     status = alter_map_call (mode,                          ;
;                                              &mc,                           ;
;                                              handle);                       ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alter_map_call		PROC                                                  \
			USES DS SI,                                           \
			mode:BYTE,                                            \
			ptr_map_struct:FAR PTR BYTE,                              \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   alter the current mapping context & call the procedure at     ;
	;   .   the target address;                                           ;
	;---------------------------------------------------------------------;
	MOVE		AH, alter_page_map_and_call_fcn
	MOVE		AL, mode
	MOVE		DX, handle
	MOVE		DS:SI, ptr_map_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alter_map_call		ENDP

END
