;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM21_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   search_handle_name                                      ;
;                                                                             ;
;      DESCRIPTION:   This function searches the handle name directory for a  ;
;                     handle with a particular name.  When it finds a handle  ;
;                     name, this function returns the handle number           ;
;                     associated with the name.  At the time of installation, ;
;                     all handles have their names initialized to ASCII       ;
;                     nulls.  By definition, a handle thus initialized has    ;
;                     no name.  To name a handle, make at least one           ;
;                     character in the name a non-null character (to          ;
;                     distinguish it from a handle without a name.)           ;
;                                                                             ;
;           PASSED:   &handle_name:                                           ;
;                        is a far pointer to a structure which contains the   ;
;                        name that is to be assigned to the handle.  The      ;
;                        structure member is described here:                  ;
;                                                                             ;
;                        name:                                                ;
;                           is an array of chars that holds the handle's      ;
;                           name.  If the name is less than eight characters  ;
;                           long, you must add nulls to make it eight         ;
;                           characters.                                       ;
;                                                                             ;
;                     &handle:                                                ;
;                        is a far pointer to the handle which matches the     ;
;                        handle name specified.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle:                                                 ;
;                        is the handle which matches the handle name          ;
;                        specified.                                           ;
;                                                                             ;
; C USE CONVENTION:   unsigned int       status;                              ;
;                     unsigned int       handle;                              ;
;                     HANDLE_NAME_STRUCT handle_name;                         ;
;                                                                             ;
;                     status = search_handle_name (&handle_name,              ;
;                                                  &handle);                  ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

search_handle_name	PROC                                                  \
			USES DS SI,                                           \
			ptr_handle_name:FAR PTR BYTE,                             \
			ptr_handle:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   search for a handle with a specified name in the "directory"; ;
	;---------------------------------------------------------------------;
	MOVE		AX, search_for_named_handle_fcn
	MOVE		DS:SI, ptr_handle_name
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the handle value matching the handle name back to the    ;
	;  .    caller;                                                       ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

search_handle_name	ENDP

END
