;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM15_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_set_context                                         ;
;                                                                             ;
;      DESCRIPTION:   This function simultaneously saves a current mapping    ;
;                     context and restores a previous mapping context for all ;
;                     mappable memory regions (both conventional and          ;
;                     expanded).  First, it copies the contents of the        ;
;                     mapping hardware from each expanded memory board into a ;
;                     destination structure.  (The application must pass a    ;
;                     pointer to the destination structure.)  Then the        ;
;                     function copies the contents of a source structure      ;
;                     into the mapping hardware on each of the expanded       ;
;                     memory boards.  (The application must pass a pointer to ;
;                     the source structure.)                                  ;
;                                                                             ;
;                     Use this function instead of save_context &             ;
;                     restore_context if you need to save or restore the      ;
;                     mapping context but don't want (or have) to use a       ;
;                     handle.                                                 ;
;                                                                             ;
;           PASSED:   &dest_context:                                          ;
;                        is a far pointer to the destination structure of the ;
;                        mapping context to be saved.                         ;
;                                                                             ;
;                     &source_context:                                        ;
;                        is a far pointer to the source structure of the      ;
;                        mapping context to be restored.                      ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        source_context.reserved:                             ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.  In this instance it contains ;
;                           the data for the mapping hardware state.          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     dest_context:                                           ;
;                        is a structure containing the state of all the       ;
;                        mapping hardware on all boards in the system.  It    ;
;                        also contains any additional information necessary   ;
;                        to restore the boards to their original state when   ;
;                        the program invokes a set_context or get_set_context ;
;                        function.                                            ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        dest_context.reserved:                               ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.  In this instance it contains ;
;                           the data for the mapping hardware state.          ;
;                                                                             ;
; C USE CONVENTION:   unsigned int   status;                                  ;
;                     CONTEXT_STRUCT dest_context;                            ;
;                     CONTEXT_STRUCT source_context;                          ;
;                                                                             ;
;                     status = get_set_context (&dest_context,                ;
;                                               &source_context);             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_set_context		PROC                                                  \
			USES DS SI DI,                                        \
			ptr_dest_context:FAR PTR BYTE,                            \
			ptr_source_context:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get current & set new memory mapping context from/to EMM;     ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_and_set_page_map_fcn
	MOVE		ES:DI, ptr_dest_context
	MOVE		DS:SI, ptr_source_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_set_context		ENDP

END
