;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM03_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_total_page_count                                    ;
;                                                                             ;
;      DESCRIPTION:   This function returns the total number of expanded      ;
;                     memory pages.                                           ;
;                                                                             ;
;           PASSED:   &total_page_count:                                      ;
;                        is a far pointer to the total page count.            ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     total_page_count:                                       ;
;                        is the total number of expanded memory pages.        ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int total_page_count;                          ;
;                                                                             ;
;                     status = get_total_page_count (&total_page_count);      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_total_page_count	PROC                                                  \
			ptr_total_page_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get total & unallocated page count from EMM;                  ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_unalloc_page_cnt_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass total page count back to the caller;                     ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_total_page_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_total_page_count	ENDP

PAGE
END
