;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM30_B.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   disable_OS_fcns                                         ;
;                                                                             ;
;      DESCRIPTION:   This function provides an OS/E with the ability to      ;
;                     disable all programs or device drivers from using the   ;
;                     OS/E specific functions.  The capability is provided    ;
;                     only for an OS/E which manages regions of mappable      ;
;                     conventional memory and cannot permit programs to use   ;
;                     any of the functions which would affect mappable        ;
;                     conventional memory regions.  When an OS/E disables     ;
;                     these functions and a program attempts to use them, the ;
;                     memory manager returns a status to the program          ;
;                     indicating that the OS/E has denied the program access  ;
;                     to the function.  In other words, the functions will    ;
;                     not work when disabled.                                 ;
;                                                                             ;
;                     The OS/E (Operating System) functions which are         ;
;                     disabled by this function are:                          ;
;                        get_hw_info               enable_DMA_reg_set         ;
;                        get_alt_reg_set           disable_DMA_reg_set        ;
;                        set_alt_reg_set           dealloc_DMA_reg_set        ;
;                        get_alt_context_size      enable_OS_fcns             ;
;                        alloc_alt_reg_set         disable_OS_fcns            ;
;                        dealloc_alt_reg_set       return_OS_access_key       ;
;                        alloc_DMA_reg_set                                    ;
;                                                                             ;
;           PASSED:   &access_key:                                            ;
;                        is a far pointer to an access key which EMM will     ;
;                        initialize.  The OS/E must use this key whenever it  ;
;                        needs to access the OS/E specific EMM functions.     ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     access_key:                                             ;
;                        is an EMM initialized access key which the OS/E must ;
;                        use whenever it needs to access the OS/E specific    ;
;                        EMM functions.  Returned only on the first function  ;
;                        invocation, the memory manager returns a random      ;
;                        valued key which will be required thereafter for the ;
;                        execution of this function.  On all invocations      ;
;                        after the first, the correct key is not returned.    ;
;                                                                             ;
; C USE CONVENTION:   unsigned int  status;                                   ;
;                     unsigned long access_key;                               ;
;                                                                             ;
;                     status = disable_OS_fcns (&access_key);                 ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

disable_OS_fcns		PROC	                                              \
			USES DI,                                              \
			ptr_access_key:FAR PTR DWORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   disable the OS related functions & obtain an "access key"     ;
	;   .   required for future use of these functions;                   ;
	;---------------------------------------------------------------------;
	MOVE		AX, disable_os_fcn_set_fcn
	MOVE		ES:DI, ptr_access_key
	MOVE		BX:CX, ES:[DI]
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the "access key" back to the OS;                         ;
	;---------------------------------------------------------------------;
	MOVE		ES:[DI], BX:CX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

disable_OS_fcns			ENDP

END
