;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM30_A.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   enable_OS_fcns                                          ;
;                                                                             ;
;      DESCRIPTION:   This function provides an OS/E with the ability to      ;
;                     enable all programs or device drivers to use the OS/E   ;
;                     specific functions.  The capability is provided ONLY    ;
;                     for an OS/E which manages regions of mappable           ;
;                     conventional memory and cannot permit programs to use   ;
;                     any of the functions which affect mappable conventional ;
;                     memory regions, but must be able to use these functions ;
;                     itself.  When an OS/E disables these functions and a    ;
;                     program attempts to use them, the memory manager        ;
;                     returns a status to the program indicating that the     ;
;                     OS/E has denied the program access to the function.  In ;
;                     other words, the functions will not work when disabled. ;
;                     However, all programs may use them when enabled.        ;
;                                                                             ;
;                     The OS/E (Operating System/Environment) functions this  ;
;                     function enables are:                                   ;
;                        get_hw_info               enable_DMA_reg_set         ;
;                        get_alt_reg_set           disable_DMA_reg_set        ;
;                        set_alt_reg_set           dealloc_DMA_reg_set        ;
;                        get_alt_context_size      enable_OS_fcns             ;
;                        alloc_alt_reg_set         disable_OS_fcns            ;
;                        dealloc_alt_reg_set       return_OS_access_key       ;
;                        alloc_DMA_reg_set                                    ;
;                                                                             ;
;                     It appears contradictory that the OS/E can re-enable    ;
;                     these functions when the function which re-enables them ;
;                     is itself disabled.  An overview of the process follows.;
;                                                                             ;
;                     The memory manager enables all the OS/E specific        ;
;                     functions, including this one, when it is loaded.  The  ;
;                     OS/E gets exclusive access to these functions by        ;
;                     invoking either of the Enable/Disable OS/E Function Set ;
;                     functions before any other software does.               ;
;                                                                             ;
;                     On the first invocation of either of these functions,   ;
;                     the memory manager returns an access_key which the OS/E ;
;                     must use in all future invocations of either of these   ;
;                     functions.  The memory manager does not require the     ;
;                     access_key on the first invocation of the               ;
;                     Enable/Disable OS/E Function Set functions.             ;
;                                                                             ;
;                     On all subsequent invocations, the access_key is        ;
;                     required for either the Enable or Disable OS/E Function ;
;                     Set functions.  Since the access_key is returned only   ;
;                     on the first invocation of the Enable/Disable OS/E      ;
;                     Function Set functions, and presumably the OS/E is the  ;
;                     first software to invoke this function, only the OS/E   ;
;                     obtains a copy of this key.  The memory manager must    ;
;                     return an access key with a random value, a fixed value ;
;                     key defeats the purpose of providing this level of      ;
;                     security for an OS/E.                                   ;
;                                                                             ;
;           PASSED:   &access_key:                                            ;
;                        is a far pointer to an access key which EMM will     ;
;                        initialize.  The OS/E must use this key whenever it  ;
;                        needs to access the OS/E specific EMM functions.     ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     access_key:                                             ;
;                        is an EMM initialized access key which the OS/E must ;
;                        use whenever it needs to access the OS/E specific    ;
;                        EMM functions.  Returned only on the first function  ;
;                        invocation, the memory manager returns a random      ;
;                        valued key which will be required thereafter for the ;
;                        execution of this function.  On all invocations      ;
;                        after the first, the correct key is not returned.    ;
;                                                                             ;
; C USE CONVENTION:   unsigned int  status;                                   ;
;                     unsigned long access_key;                               ;
;                                                                             ;
;                     status = enable_OS_fcns (&access_key);                  ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

enable_OS_fcns		PROC	                                              \
			USES DI,                                              \
			ptr_access_key:FAR PTR DWORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   enable the OS related functions & obtain an "access key"      ;
	;   .   required for future use of these functions;                   ;
	;---------------------------------------------------------------------;
	MOVE		AX, enable_os_fcn_set_fcn
	MOVE		ES:DI, ptr_access_key
	MOVE		BX:CX, ES:[DI]
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the "access key" back to the OS;                         ;
	;---------------------------------------------------------------------;
	MOVE		ES:[DI], BX:CX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

enable_OS_fcns			ENDP

END
