;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM29_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   prep_EMM_warmboot                                       ;
;                                                                             ;
;      DESCRIPTION:   This function prepares the expanded memory hardware for ;
;                     an impending warm boot.  This function assumes that the ;
;                     next operation that the operating system performs is a  ;
;                     warm boot of the system.  In general, this function     ;
;                     will effect the current mapping context, the alternate  ;
;                     register set in use, and any other expanded memory      ;
;                     hardware dependencies which need to be initialized at   ;
;                     boot time.  If an application decides to map memory     ;
;                     below 640K, the application must trap all possible      ;
;                     conditions leading to a warm boot and invoke this       ;
;                     function before performing the warm boot itself.        ;
;                                                                             ;
;           PASSED:   Nothing.                                                ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                                                                             ;
;                     status = prep_EMM_warmboot();                           ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

prep_EMM_warmboot	PROC

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   prepare the EMM hardware for an impending warm boot by the OS ;
	;   .   (reset it to its initial state at power on);                  ;
	;---------------------------------------------------------------------;
	MOVE		AH, prepare_for_warmboot_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

prep_EMM_warmboot		ENDP

END
