;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_G.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   enable_DMA_reg_set                                      ;
;                                                                             ;
;      DESCRIPTION:   This function allows DMA accesses on a specific DMA     ;
;                     channel to be associated with a specific DMA register   ;
;                     set.  In a multitasking operating system, when a task   ;
;                     is waiting for the completion of DMA, it is useful to   ;
;                     be able to switch to another task until the DMA         ;
;                     operation completes.  Any DMA on the specified channel  ;
;                     will go through the specified DMA register set          ;
;                     regardless of the current register set.  If a DMA       ;
;                     channel is not assigned to a DMA register set, DMA for  ;
;                     that channel will be mapped through the current         ;
;                     register set.                                           ;
;                                                                             ;
;           PASSED:   DMA_reg_set:                                            ;
;                        is the number of the DMA register set to be used for ;
;                        DMA operations on the DMA channel specified by       ;
;                        DMA_channel.  If the DMA register set specified is   ;
;                        zero, no special action will be taken on DMA         ;
;                        accesses for the DMA channel specified.              ;
;                                                                             ;
;                     DMA_channel:                                            ;
;                        is the DMA channel which is to be associated with    ;
;                        the DMA map register set specified by DMA_reg_set.   ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int DMA_reg_set;                               ;
;                     unsigned int DMA_channel;                               ;
;                                                                             ;
;                     status = enable_DMA_reg_set (DMA_reg_set,               ;
;                                                  DMA_channel);              ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

enable_DMA_reg_set	PROC	                                              \
			DMA_reg_set:WORD,                                     \
			DMA_channel:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   enable DMA into expanded memory using the DMA register set    ;
	;   .   specified by the OS;                                          ;
	;---------------------------------------------------------------------;
	MOVE		AX, enable_dma_on_alt_fcn
	MOVE		BX, DMA_reg_set
	MOVE		DX, DMA_channel
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

enable_DMA_reg_set		ENDP

END
