;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM26_C.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_total_raw_page_count                                ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of non-standard length ;
;                     pages within expanded memory to the operating system.   ;
;                                                                             ;
;                     One variety of expanded memory board has a page size    ;
;                     which is a sub-multiple of 16K bytes.  An expanded      ;
;                     memory page which is a sub-multiple of 16K is termed a  ;
;                     raw page.  An operating system may deal with mappable   ;
;                     physical page sizes which are sub-multiples of 16K      ;
;                     bytes.                                                  ;
;                                                                             ;
;                     If the expanded memory board supplies pages in exact    ;
;                     multiples of 16K bytes, the number of pages this        ;
;                     function returns is identical to the number the         ;
;                     get_unalloc_page_count function returns.  In this case, ;
;                     there is no difference between a page and a raw page.   ;
;                                                                             ;
;           PASSED:   &total_raw_pages:                                       ;
;                        is a far pointer to a count of the total number of   ;
;                        raw pages that are in the system.                    ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     total_raw_pages:                                        ;
;                        is a count of the total number of raw pages that are ;
;                        in the system.                                       ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int total_raw_pages;                           ;
;                                                                             ;
;                     status = get_total_raw_page_count (&total_raw_pages);   ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_total_raw_page_count	PROC                                          \
				ptr_total_raw_pages:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the number of total RAW pages from EMM;                   ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_unallocated_raw_pg_cnt_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the total RAW page count back to the caller;             ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_total_raw_pages
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_total_raw_page_count	ENDP

END
