;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM07_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_EMM_version                                         ;
;                                                                             ;
;      DESCRIPTION:   This function returns the version number of the memory  ;
;                     manager software.                                       ;
;                                                                             ;
;           PASSED:   &version:                                               ;
;                        is a far pointer to the memory manager's version     ;
;                        number.                                              ;
;                                                                             ;
;         RETURNED:   version:                                                ;
;                        is the memory manager's version number in binary     ;
;                        coded decimal (BCD) format.  The upper four bits     ;
;                        contain the integer digit of the version number.     ;
;                        The lower four bits contain the fractional digit of  ;
;                        version number.  For example, version 4.0 is         ;
;                        represented like this:                               ;
;                                        0100  0000                           ;
;                                           /   \                             ;
;                                          4  .  0                            ;
;                        When checking for a version number, an application   ;
;                        should check for a version number or greater.        ;
;                        Vendors may use the fractional digit to indicate     ;
;                        enhancements or corrections to their memory          ;
;                        managers.  Therefore, to allow for future versions   ;
;                        of memory managers, an application shouldn't depend  ;
;                        on an exact version number.                          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int version;                                   ;
;                                                                             ;
;                     status = get_emm_version (&version);                    ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_EMM_version		PROC                                                  \
			ptr_version:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get EMM version number;                                       ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_emm_version_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the EMM version number back to the caller;               ;
	;---------------------------------------------------------------------;
	MOVE		DH:DL, 0:AL
	MOVE		ES:BX, ptr_version
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_EMM_version		ENDP

END
