;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM01_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_EMM_status                                          ;
;                                                                             ;
;      DESCRIPTION:   This function returns a status code indicating whether  ;
;                     the memory manager is present and the hardware is       ;
;                     working correctly.                                      ;
;                                                                             ;
;           PASSED:   Nothing.                                                ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                                                                             ;
;                     status = get_emm_status ();                             ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_EMM_status		PROC	

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get status from EMM;                                          ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_status_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_EMM_status		ENDP

PAGE
END
