; Device driver template
;
	ideal
	locals

max_cmd 	=	12	;only 12 functions recognized by the driver
cr		=	0dh
lf		=	0ah
TRUE		=	-1
FALSE		=	0

	model	tiny,pascal
	CodeSeg

	org	0		;device drivers start at offset 0

;
; Device Driver Header
;
header	dd	-1		;link to next device, -1 = end of list
        dw	8000h		;simple character device driver
	dw	strat		;device Strategy entry point
	dw	intr		;device Interrupt entry point
	db	'$DRIVER$'	;Device name

rh_ptr	dd	?		;saved request header pointer

;
; Command codes dispatch table.  Only functions 0 (initialize) and 4 (read)
; are supported.  Other functions go to a stub routine that simple returns
; a non-error status.
;
dispatch:
	dw	init		; 0 = initialize driver
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
	dw	not_imp		; not implemented
;
; MS-DOS Request Header structure definition
;
struc	request
rlength	db	?		;length of request header
unit	db	?		;unit number for this request (block devices)
command	db	?		;request header's command code
status	dw	?		;driver's return status word
reserve	db	8 dup (?)	;reserved area
media	db	?		;media descriptor byte (block devices)
address	dd	?		;memory address for transfer
count	dw	?		;byte/sector count value
sector	dw	?		;starting sector value (block devices)
ends	request			;end of request header template

; Status codes returned by routines in AX
error		=	8000h
busy		=	0200h
done		=	0100h
unknown_command	=	3

;
; Device strategy routine -- save address of request header.
;
strat:	mov	[word ptr cs:rh_ptr],bx
	mov	[word ptr cs:rh_ptr+2],es
	retf

;
; Interrupt routine.  Dispatch to the proper routine.
;
proc	intr	far uses ax bx cx dx ds es di si
	pushf
	push	cs
	pop	ds				;point to local data
	les	di,[rh_ptr]			;ES:DI = Request Header
	mov	bl,[es:di+request.command]	;bx = command code
	xor	bh,bh
	cmp	bx,max_cmd			;make sure it's legal
	jle	intr1
	mov	ax,error+unknown_command 	;Error:  unknown command
	jmp	short intr2
intr1:	shl	bx,1				;form index to dispatch table
	call	[word ptr bx+dispatch]		;and branch to driver routine
	les	di,[rh_ptr]			;ES:DI = request header
intr2:	or	ax,done				;set Done bit
	mov	[es:di+request.status],ax	;store status in request header
	popf
	ret
endp	intr

;
; 'stub' routine for un-implemented functions.
;
not_imp:
	xor	ax,ax			;set good status
	retn

	Even
;
; Initialization code.
;
; Initialize the function pointers table and the global data buffer, and 
; return the address of the first byte of free memory after all the device
; driver code.  The global variables buffer overlays this initialization code.
;
; Upon entry, ES:DI points to the MS-DOS request header.  DS contains the
; local data segment (same as CS).  This routine makes no attempt to save
; any registers.
;
init:	mov	ax,cs
	mov	es,ax
	mov	di,offset dhaddr
	call	hexasc			;convert load segment address to ASCII
	push	cs
	pop	es
	mov	ax,offset header
	mov	di,offset dhaddr+5
	call	hexasc
	mov	ah,9			;print sign-on message and
	mov	dx,offset ident		;driver load address
	int	21h
	les	di,[rh_ptr]		;request header address in ES:DI
;store first usable memory address in request header
	mov	[word ptr es:di+request.address],offset init
	mov	[word ptr es:di+2+request.address],cs
	ret

ident	db	cr,lf,lf
	db	'Device driver',cr,lf
	db	'Device Header at '
dhaddr	db	'XXXX:0000.',cr,lf,lf,'$'

;
; hexasc - converts a binary 16-bit number into a hex ASCII string
;
; call with AX = value to convert, ES:DI = address to store 4-character
; string.
;
hexasc:	mov	bx,ax		;save value here
	mov	cx,4		;initialize character counter
	mov	dx,cx
hexasc1:
	xchg	cx,dx
	rol	bx,cl		;isolate next 4 bits
	mov	al,bl
	and	al,0fh
	add	al,'0'		;convert to ASCII
	cmp	al,'9'		;if 0-9
	jbe	hexasc2		;then jump
	add	al,'A'-'9'-1	;otherwise add offset for A-F
hexasc2:
	stosb
	xchg	cx,dx
	loop	hexasc1
	ret

	end	header
