;RM82TS8,16,24,32,40,48
; Updated 11/24/90

;============================================================================
;
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

;============================================================================
; DECLARE SUB EXIST (FILNAME$, ErrCode%, Mode%)
; CALL EXIST(FILENAME$+CHR$(0), ErrCode%, Mode%)
; Filename$ must be an ASCII Null string (end in CHR$(0)).
; Filename$ can not be a TYPEd string or a variable in a string array
; because there is a chance that string will be outside DGROUP.  String
; cocentenation is used to make sure it is in DGROUP.
;
; Mode%: 
;      =  0 if just want to see if file exits
;      <> 0 if want to see if can read and write to file
;
; Returns ErrCode%    = 0 (False) if no error
;                     = True if an error,
; Codes:
;      -1 = string wrong length
;       2 = file not found
;       3 = path not found
;       4 = no free handles
;       5 = access denied          (tried to read a subdirectory)
;      12 = invalid access code    (wont see this unless Mode% = 1)
;      20 = Write protect error    (wont see this)
;      21 = Invalid drive
;      22 = Drive not ready        (floppy drive door open)
;      23 = unknown command
;      24 = CRC error
;      25 = Bad request structure
;      26 = Seek error
;      27 = Unkown disk format
;      28 = Sector not found
;      29 = Printer out of paper   (shouldn't see this)
;      30 = Write fault            (shouldn't see this)
;      31 = Read fault
;      32 = General, non-specific error (usually a network drive error)
;      35 = Invalid Disk Change    (shouldn't see this)
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC  EXIST
.CODE
; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

NAMESTRG        EQU     [BP+10]       ; easy memory jogger for stack names
ERRCODE         EQU     [BP+8]        ; easy memory jogger for stack names
MODE		EQU	[BP+6]	      ; easy memory jogger for stack names

EVEN
CE_Off          DW      0             ; to save space in DGROUP
CE_Seg          DW      0             ; address of previos handler
Last_Error      DW      0             ; store last error code

EVEN
EXIST   PROC    FAR
		Push    BP	      ; save stack frame
		Mov     BP,SP
				      ; Change Vector
		Mov     AX,3524h      ; use DOS to get current
		Int     21h           ; address of the vector
		Mov     CE_Seg, ES    ; save for removal
		Mov     CE_Off, BX    ; address returned in ES:BX
		Push    DS            ; hold DS a moment
		Mov     AX,CS
		Mov     DS,AX         ; set CS == DS

		Assume  DS:@code

		;need this so offset is calculated with reference to 
		;CSEG rather than DGROUP

		Mov     DX, OFFSET CE ; get address of our MASM handler
		Mov     AX, 2524h     ; tell DOS we're taking this vector
		Int     21h           ; grab the vector
		Pop     DS            ; restore DS

		Assume  DS:@data      ; tell MASM DS is restored

		Mov     AX,-1         ; assume an error
		Mov     BX,NAMESTRG   ; get string descriptor
		Mov     CX,[BX]       ; put length of string in CX
		Jcxz    Finis         ; FILENAME$ is a null string so exit

comment |
		;This is an alternative routine, but because it does not
		;reset the DTA, it can cause problems with routines
		;that use the COMMAND$ inside QBASIC.  The default DTA
		;will overwrite the COMMAND$ storage area in the PSP.

		Mov     CX,100111b   ;search for all file types
				     ;BUT volume and subdirectories
		Mov     AX,4E00h     ;use FIND FIRST function
		Int     21h
		Jnc     FileFound
		Mov     AX,-1        ;report error & quit
		Jmp     Short fini
FileFound:
		Xor     AX,AX        ;report no error & quit
	|

		Xor     AX,AX         ; assume no error
		Mov     CS:[Last_Error],AX ; store it
		Mov     DX,[BX+2]     ; get string address into DS:DX
		Mov	BX,MODE
		Mov	AX,[BX]	      ; read MODE status
		Or	AX,AX	      ; is MODE = 0? (read only mode)
		Jz	Open_Handle   ; yes, so skip ahead
		Mov     AL,010b       ; load (read/write) access
Open_Handle:
		Mov	AH,3Dh        ;  open file handle 
		Int     21h           ; sets carryflag if not found
		Jnc     Looks_good    ; Could it be o.k. ?
				      ; (Carry set if file not found)
		Cmp     CS:[Last_Error],0   ; was this a CE err or normal err
		JE      Finis         ; Normal, quit with error code from DOS
		Jmp     Short Dos_Error   ; else quit with CE error
Looks_good:
		Cmp     CS:[Last_Error],0  ; did DOS report an error?
				      ; this is a safety check
		JE      File_Found    ; nope, so skip ahead
		Jmp     Short Dos_Error   ; report an error occured, so quit
File_Found:
		Mov     BX,AX         ; if valid handle returned, store in BX
		Mov     AH,3Eh        ; close file handle in BX, handle found
		Int     21h           ; the following will trap a file close
				      ; error
Dos_Error:
		Mov     AX,CS:[Last_Error] ; get last error message in AX
Finis:
		Mov     BX,ERRCODE
		Mov     [BX],AX       ; store value of ErrCode%
		Push    DS            ; Reset old CE vector
		Mov     DX, CE_Off    ; get old values
		Mov     AX, CE_Seg
		Mov     DS, AX
		Mov     AX, 2524h     ; SET VECTOR call
		Int     21h           ; restore it
		Pop     DS            ; restore registers
		Pop     BP
		Ret     6             ; remove the 3 (2 * 3) parameters
EXIST   ENDP

;===========================================================================
; Substitute critical error handler, does nothing but capture error.
; This would be unsafe for most routines but not here.
;===========================================================================

EVEN
CE   PROC  FAR
		Assume  DS:NOTHING, ES:NOTHING
		Pushf                 ; save flags
		Mov     AX,DI         ; get error code
		Add     AX,20         ; add 20 to it (so can tell origen of
				      ; error, CE or Function 03Dh)
		Mov     CS:[Last_Error],AX   ; store error code
		Xor     AL,AL         ; tell DOS to ignore error
		Popf                  ; restore flags
		Iret
		Assume  DS:@data
CE  ENDP
END

