;RM82TS8,16,24,32,40,48
;Updated 12/14/90

DOSSEG
.MODEL MEDIUM

     PUBLIC GETCPU

.code
;==============================================================================
;PreFetchQueue
;       On exit:
;
;               DX      = length of prefetch instruction queue
;
;       This subroutine uses self-modifying code, but can
;       nevertheless be run repeatedly in the course of the calling
;       program, since only executed in real mode by pre 286 chips
;
;  This routine came from the public domain program InfoPlus Ver 1.35
;  by Andrew Rossman 10/7/90
;
;  I believe that the logic came from earlier efforts:
;Copyright free.
;  Bob Smith            May 1985.
;  Qualitas, Inc.
;  8314 Thoreau Dr.
;  Bethesda, MD  20817
;  301-469-8848
;
;  Bob Smith credited Arthur Zachai with suggesting the technique to dis-
;  tinguish  between  the 808x and 8018x families by exploiting the 
;  difference in the length of their pre-fetch instruction queues.
;==============================================================================
count   =       7
opincDX equ     42H                     ; inc DX opcode
opnop   equ     90H                     ; nop opcode

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

EVEN
PreFetchQueue     proc    near
	Mov     AL,opincDX
	Mov     CX,count
	Push    CX
	Push    CS
	Pop     ES
	Mov     DI,offset PreFetchQueue_01 - 1
	Push    DI
	STD
	Rep stosb
	Mov     AL,opnop
	Pop     DI
	Pop     CX
	Xor     DX,DX
	CLI
	rep stosb
	rept    count
	inc     DX
	endm
PreFetchQueue_01:
	STI
	cld
	Ret
PreFetchQueue     endp

;==============================================================================
; DECLARE FUNCTION GETCPU% ()
; Checks for CPU type
; Returns:
;	88 for 8088
;	86 for 8086
;	20 for NEC V20
;	30 for NEC V30
;	186 for 80186 or 80188 (I have never seen an 80188 so no special test)
;	286 for 80286
;	386 for 80386
;	386 for 80486.  I offer no special test for 80486 because the only 
;			published code I found in PC Magazine wrecks Windows
;			I can't offer other code because I don't have 	MS MASM
;			or Borland TASM so as to compile protected mode
;			software.  The Code that crashes Windows is shown below
;
; 	  Based on uncopyrighted, published logic by
;         Clif (that's the way he spells it) Purkiser of Intel -
;         Santa Clara.  Now set forth in the MS's published HIMEM.SYS as the
;	  "oficial Intel Method."
;
;         Some ideas by Pat Shea from his 
;         Pat Shea' Copr. 1987 routine  "(that Copr. is on there cuz my
;                                        lawyer sez I should, but feel
;                                        free to hack away!!!    pats.)"
;	  As improved by DON HIGGINS (COMPUSERVE 73047,1113) (MASM code)
;	  Fixed 05/25/88 73710,3667 TRT
;
;         Most of this routine came from the public domain program InfoPlus
;	  Ver 1.35 by Andrew Rossman 10/7/90.  I reordered it to preserve
;	  the necessary registers for QBASIC and eliminate the unknown chip
;	  value.
;==============================================================================

EVEN
GETCPU     PROC     FAR
	Push    SI              ; because we will change it
	Push	DI
	Pushf			; prepare to manipulate flag register
	Xor	AX,AX		; must do it through pushs and pops
	Push	AX		; because no direct method to manipulate
	Popf			; put a 0 in the flags
	Pushf
	Pop	AX		; get value back from flags
	And	AX,8000h	; chips less than 286 wont clear high bits of
	Cmp	AX,8000h	; flags.  All bits set on 808x, NEC, 8018x?
	JE	Test_Real	; yep, so check for NEC, 808x, 8018x chips
	Mov	AX,7000h	; else see if set other flag bits
	Push	AX		; to distinguish 286 from 386/486 chip
	Popf
	Pushf
	Pop	AX
	And	AX,7000h	; bits 12 -14 can't be set in real mode on 286
				; the NT & IOPL bits
	Jz	Found_286	; if can't set, then have a 286

Found_386:
	Mov	AX,386		; else report have a 386 or 486
	Jmp	short Finis

Found_286:
	Mov	AX,286		; report have a 286
	Jmp	short Finis

Test_Real:
	Mov	AX,0ffffh	; see if can shift left more than 32 times
	Mov	CL,21h		; 8018x chips (286/386/486 too) wont allow this
	Shl	AX,CL		; but 808x chips will shift AX to 0
	Jnz	Found_186

Test_86:
	Call    PreFetchQueue   ; find length of PIQ
				; result returned in DX
	STI			; interrupts must be allowed
	Xor	SI,SI		; clear offset address
	Mov     CX,-1		; load 64k in CX for size of loop
	Rep     Lods Byte Ptr ES:[SI]	; only  NEC can rep w/ segment override
	JCXZ    short Test_NEC	; if CX got to 0 then we have a NEC

	Mov	BX,86		; assume an 8086
	Cmp     DX,4		; was PIQ = 4, then have an 8088
	Ja	@f		; if more than 4 have 8086
	Mov	BX,88		; else report 8088
@@:
	Mov	AX,BX		; get value back from BX
	Jmp	short Finis

Test_NEC:
	Mov	BX,30		; assume a V30
	Cmp	DX,4		; if PIQ = 4, then have a V20
	Ja	@f		; if more than 4, then have a V30
	Mov	BX,20		; else report a V20
@@:
	Mov	AX,BX		; get value back from BX
	Jmp	Short Finis

Found_186:
	Mov	AX,186		; report have an 80186 (Tandy 2000)
				; I have never seen an 80188 so that is not
				; tested for.  If you want to test use prefetch 
				; instruction que test.
Finis:
	Popf
	Pop	DI
	Pop	SI		; because we changed it
	Ret
GETCPU     ENDP

Comment		|
check_for_80386:

;=====================================================================;
;   Cpu type is an 80386 Or 80486       PCMAG, July 1990, page 426
;  Unfortunately, use of this CODE will cause WINDOWS 3.0 to request that
;  the user reboot (a violation of protected mode security)
;  So .code is commented out.  I suspect in protected mode that there
;  is no way to determine the difference between a 386 or 486 because
;  any test will cause a violation of some protected mode feature.
;=====================================================================;
	DB                 0Fh,20h,0C0h             ;Mov EAX,CR0
	DB                 66h,8Bh,0D8h             ;Mov EBX,EAX
	DB                 66h,35h,00,00,00,20h     ;Xor EAX,20000000h
	DB                 0Fh,22h,0C0h             ;Mov CR0,EAX
	DB                 0Fh,20h,0C0h             ;Mov EAX,CR0
	DB                 66h,3Bh,0C3h             ;Cmp EAX,EBX
	JE                 is_386
	DB                 0Fh,22h,0C3h             ;Mov CR0,EBX
	Mov                AX,486
	Jmp                Short Finis
is_386:

	Mov                AX, 386
	|
END
