;RM82TS8,16,24,32,40,48
;updated 12/12/90

DOSSEG
.MODEL MEDIUM, BASIC
.CODE

;=============================================================================
; DECLARE SUB OTHEROPER (DPMI%, WINDOWS%, DESQ%)
; CALL OTHEROPER(DPMI%, WINDOWS%, DESQ%)
; Purpose: Checks if DPMI, or MS Windows or Quarterdeck DESQVIEW is active
; Returns:
;	For each variable that exists -1
;       Else if multitasking environment does not exist then returns 0
;	Returns 0 if used with DOS versions < 3.x
;=============================================================================

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

EVEN
OTHEROPER PROC FAR BASIC, DPMI:WORD, WINDOWS:WORD, DESQ:WORD

;These tests came from a public domain program called SYSINFO Ver
;1.35.   It is written in Ver 5.5 Turbo Pascal by Andrew Rossmann (10/7/90)

	;DOS Version Test if less then 3, then report not found
	Mov     AX,3000h        ;check & see if software cd be installed
	Int     21h             ;not possible before DOS Ver. 3.x
	Cmp     AL,3            ;major version in AL
	JB      Dos_Ver_2x      ;less than 3.xx so quit with not found

	; IF DPMI found, then DH = Major Version
	;                then DL = Minor Version
	;		 CL = Chip Type
	;			2=286
	;			3=386
	;			4=486 
	Mov     AX,1687h        ; test for DPMI
	Int	2Fh
	Or	AX,AX
	JNZ	DPMI_Not_Found
	Mov	AX,-1
	Jmp     Short @f

DPMI_Not_Found:
	Xor	AX,AX
@@:
	Mov	BX,DPMI
	Mov	[BX],AX
	
;search for MS Windows
;version information display not implemented
	Mov     AX,1600h        ; test for Windows
	Int	2Fh
	Cmp     AL,1            ; if 1 then Windows 386 Ver 2.x
	JE	Win_386
	Cmp     AL,0FFh         ; if -1 then Windows 386 Ver 2.x
	JE	Win_386
	OR      AL,AL           ; if zero
	JZ      Win_Real
	Cmp     AL,80h          ; or 80h then test some more
	JE	Win_Real

Win_Enhanced:                   ; else, the default case
	;Major Version in AL, 
	;Minor Version in AH
	Mov	AX,-1
	Jmp	Short	Win_End

Win_386:                        ; nothing special returned
	Mov	AX,-1
	Jmp	Short	Win_End

Win_Real:                       ; Real Mode test
	Mov	AX,4680h
	Int	2Fh
	Or      AX,AX           ; see if AX = 0
	JZ      @f              ; if yes, then Windows found
	Xor     AX,AX           ; else no Windows
	Jmp	Short	Win_End
@@:
	Mov     AX,-1           ; report Win_Real found

Win_End:
	Mov     BX,WINDOWS      ; store values
	Mov	[BX],AX

;Search for DESQView
;If DESQView found then, If BX = 2 then Version 2.00
; 		else BH = major version
;		     BL = minor version

	Mov	AX,2B01h
	Mov     CX,4445h        ;'DE'
	Mov     DX,5351h        ;'SQ'
	Int	21h
	Cmp	AL,0FFh
	JE	DESQ_Not_Found
	Mov	AX,-1
	Jmp     SHORT @f

DESQ_Not_Found:
	Xor	AX,AX
@@:
	Mov	BX,DESQ
	Mov	[BX],AX
Finis:
	Ret

Dos_Ver_2x:
	Xor     AX,AX           ; report not found
	Mov     BX,DPMI         ; store 0 in all variables
	Mov     [BX],AX         ; DOS Version 2.x
	Mov     BX,WINDOWS      ; did not initialize a vector for INT 2Fh.
	Mov     [BX],AX         ; Thus this method prevents a crash
	Mov     BX,DESQ         ; if Int 2fh were called but not
	Mov     [BX],AX         ; initialized.
	Jmp	Short	Finis
OTHEROPER  ENDP
END
