;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Example program number 2        ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;  This program will fill an allocated memory block
;


.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros

fill_message   db ' bytes allocated.  Now Filling block ...  ',10,13,36



Start32:                        ; first intruction executed here


;
; Use the Memory Allocation Service and attept to allocate 4GB
;
        mov     edx,-1
        call    Allocate_memory
        cmp     eax,0
        jnz enfmem
           mov  ah,4ch
           int  21h
enfmem:

; EDX now equals a near pointer of the memory block and
; EAX equals the number bytes that were allocated




;
; Print the amount of memory that was accualy allocated
;
        push    eax
        push    edx                             ; Save EDX.
        call    print_hex                       ; Print EAX then
        mov     edx,offset fill_message         ; print a message
        mov     [real_ds],Code32
	mov     ah,9
        dosint  21h
        pop     edx                             ; restore EDX
        pop     eax


;
; Fill the allocated memory block
;
        mov     edi,edx                         ; EDX = offset
        mov     ecx,eax                         ; EAX = count
        shr     ecx,2
        rep     stosd

;
; Termiate the program
;
        mov   ah,4ch
        int   21h





;
; A procedure that will print EAX on the screen
;
Print_hex   PROC NEAR
LOCAL   digit :DWORD
        pushad
        mov     digit,eax
	mov     ecx,8
L11:
	rol     digit,4
        mov     al,byte ptr digit
        and     al,0fh
        cmp     al,10
	jb j8
        add      al,'A'-'0'-10
j8:     add     al,'0'
        mov     bh,0
        mov     ah,0Eh
        dosint  10h
        loop L11
        popad
        ret
print_hex ENDP



CODE32 ENDS
END
