;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Example program number 5        ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;
;This program hooks IRQ 0 and loads and executes COMMAND.COM
;



.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros


align 4
savedIRQ0       dd 0,0
command_com     db 'C:\COMMAND.COM',0
parmBlock       db 10h dup (0)
meag_v86        db ' Exiting protected mode ',10,13,36
mesg_pmode      db 'Got into 32bit protected mode ',10,13
                db  10,'Press any key to load and execute COMMAND.COM$'


real_ds_temp    dd 0
start32:                ; 32 bit code entry point.


      ; *****************  print a message *****************

        mov edx,offset mesg_pmode         ; NOTE:  only DX is used here
        mov  [real_DS], CODE32
        mov ah,9
        dosint  21h                     ; print string

        mov     ah,0                    ; wait for key
        dosint  16h



  ;********** Hook IRQ 0 just for fun ************************

        mov     bl,0                        ;Save IRQ 0 interrupt vector
        call    GetIRQVector
        mov     dword ptr savedIRQ0[0],edx
        mov     word ptr savedIRQ0[4],cx

        mov   bl,0                      ; Set the new IRQ 0 vector
        mov  edx,offset  timer_int      ; See below
        call    SetIRQVector



;************** LOAD AND EXECUTE A PROGRAM ( command.com ) *****************
;
; Get boot drive and put in ASCIIZ name
;
        mov     ax,3305h
        dosint  21h
        add     dl,'@'
        mov     command_com[0],DL

;
; Set up the paramter block for the "load and execute" DOS service
;
        mov     ax,environment_segment
        mov	word ptr parmBlock,ax   	; set environment segment
        mov     bx,PSP_segment

        mov	word ptr parmBlock+2,80h	; set command line
        mov	word ptr parmBlock+4,bx


        mov	word ptr parmBlock+6,5Ch	; Set FCB 1
        mov	word ptr parmBlock+8,bx
        mov	word ptr parmBlock+0Ah,6Ch	; Set FCB 2
        mov     word ptr parmBlock+0Ch,bx

;
; Call the 32bit version of the "load and execute" DOS service
;
        mov     ebx,offset parmBlock    ; ES:EBX -> parameter block
        mov     ah,4Bh
        mov	al,0
        mov     edx,offset command_com   ; DS:EDX -> ASCIIZ string
        Int     21h



; *****************  print another message *****************
        mov edx,offset meag_v86         ; NOTE:  only DX is used here
        mov ah,9
        dosint 21h

exit:
        mov   ah,4ch            ; Terminate program
        int   21h


;
; *****************  IRQ 0  interrupt  handler *****************
;
timer_int:
        push  ds                        ; must save all registers used
        push  eax
        mov  ds,cs:Data32_sel           ; Note, CS: must be used
        mov  eax,_0B8000h
        inc word ptr [eax]              ; increment character on the screen
                                	; just to show it's doing something
        pop  eax
        pop   ds
        jmp fword ptr CS:savedIRQ0      ; continue on interrupt chain.
                                        ; must use CS because DS is unknown

CODE32 ENDS

END
