comment $



     FOR 32 BIT PROTECDED MODE ONLY
 Writen by Adam Seychell


  VARIOUS PROCEDURES   

                                                                     
      THIS FILE CONTAINS USEFUL TEXT PLOTTING PROCEDURES             
                                                                     





$




.386

CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,FS:CODE32,GS:CODE32,SS:CODE32


INCLUDE         DOS32.INC
INCLUDE         MACROS.386
INCLUDE         TEXT.INC


comment $
͸
                         PRINT CHARACTER                                  
                                                                          
                                                                          
 INPUT:        AL character to be displayed                               
                Cursor_X & Cursor_Y is position on screen                 
 GlobalTextColor This contains the current color used.                    
 NOTE: if the color value above 0ffh the character's attribute byte will  
 not be written too.                                                      
                                                                          
 OUTPUT:                                                                  
 Prints  the character on the screen at the cursor position, also updates 
  the cursor and scrolls screen if nessesary.                             
                                                                          
 $
Print_Char      proc PASCAL  USES EAX EDX
               cmp      Init_flag,FALSE
               je   Init_cursor
cursor_inited:
               cmp      al,10
               je       line_feed
               cmp      al,13
               je       carg_ret

                push    ax
                movzx   eax, Cursor_Y
		mov	edx,eax
		shl	eax,6
		shl	edx,4
		add	eax,edx
                movzx   edx,Cursor_X
                add     eax,edx
                shl     eax,1
                add     eax,_0b8000h
                pop     dx
                cmp     GlobalTextColor,100h
                jae J88
                mov     dh,byte ptr GlobalTextColor
                mov     [eax+1],dh
        J88:    mov     [eax],dl
                inc Cursor_X

		; ----- don't let the curser go off the screen -----------
char_printed:
                cmp Cursor_X,80
                jb k23
                mov Cursor_X,0
                inc Cursor_Y
        k23:    cmp Cursor_Y,24
                ja scroll_screen
                ret


;-- line feed ----------------------------------
line_feed:    inc Cursor_Y       ; move curser down a line
              jmp char_printed
;-- carage return ------------------------------------
carg_ret:    mov Cursor_X,0         ; return curser to start
             jmp char_printed

;------- Scroll the Screen up a line --------
scroll_screen:
        push    es
	pushad
        push    ds
        pop     es
        mov     edi,_0b8000h
        mov     esi,edi
        add     esi,0A0h
        cld
        mov     ecx,1000-40
        rep movsd
        ;-now screen is scrolled up, must clear bottom line
         mov     ecx,80
         mov     ah,[edi+1]
         mov     al,0
         rep     stosw
         popad
         pop   es
         mov Cursor_Y,24
         ret


;------------ initalize the cursor postion to BIOS's -----------------
Init_flag       db False
Init_cursor:    pushad
                mov      Init_flag,True
	        mov     ah,03h
	        mov     bh,0
                dosint  10h
                mov     Cursor_X,DL
                mov     Cursor_Y,DH
                mov     bl,21h
                call    GetINTvector
                mov     dword ptr old_int21vec,edx
                mov     word ptr old_int21vec+4,cx
                mov     edx,Offset Exit_trap
                call    SetINTvector
                popad
                jmp     cursor_inited

old_int21vec    df 0
Exit_trap:
                cmp  ah,4ch          ; Trap program Termination
        	jne noterm
	        pushad
	        mov     ah,2
                mov     DL,Cursor_X
                mov     DH,Cursor_Y
                xor     BH,BH
                dosint  10h
                popad
noterm: jmp cs:old_int21vec

PRINT_CHAR      endp


GlobalTextColor         dd -1
; This contains the current color used by the Print_Char routine ( above ).
; NOTE: if the color value above 0ffh the character's attribute byte will
; not be written too.


Cursor_Y        db      ?
Cursor_X        db      ?
; These are the cursor location for the Print_Char routine ( above )
; Thier initalized to the BIOS's position at start up.






comment $
͸
                         CLEAR THE  SCREEN                                
                                                                          
 INPUT:    NOTHING                                                        
                                                                          
 OUTPUT:       Clears the screen with current color                       
 $
ClrScr  proc PASCAL  USES edi ecx eax
        mov     ax,0700h
        cmp     GlobalTextColor,100h
        jae J28
         mov     ah,byte ptr GlobalTextColor
J28:    mov edi,_0b8000h
        cld
        mov ecx,2000
        rep stosw
        ret
ClrScr endp


comment  %
͸
                        DISPLAY STRING                                    
                                                                          
 Expects:      DS:EDX  pointing to the string                             
                String is terminated with character '$'                   
                                                                          
 %
; PRINTS A STRING ON SCREEN
String proc PASCAL   USES eax edx
textlop:	mov al,[edx]
                inc edx
	        cmp al,'$'
                jz exit_text
                call print_char
               jmp textlop
exit_text:      ret
String ENDP




comment $
͸
                                                                          
  Three procedures to print the Binary values of EAX, AX                  
 and AL respectivly.                                                      
                                                                          
 $
; ***************  prints Binary EAX  ******************
Print_BinDword  PROC PASCAL  USES EDX
        mov     dh,32
        Call    binSizeSet
        RET
Print_BinDword        ENDP


; ***************  prints Binary AX  ******************
Print_BinWord      PROC PASCAL  USES  EDX
        mov 	dh,16
        rol     eax,16
        Call  	binSizeSet
        RET
Print_BinWord        ENDP


; ***************  prints Binary AL  ******************
Print_BinByte      PROC PASCAL  USES EDX
        mov 	dh,8
        rol     eax,24
        Call    BinSizeSet
        RET
Print_BinByte        ENDP

BinSizeSet PROC
                push    eax
        binary_digit:
                rol     ecx,1
		mov	al,cl
		and	al,1
		add	al,'0'

                call	print_char	; send character to screen
                dec	dh
                jnz	binary_digit
                pop     eax
        	ret
BinSizeSet ENDP

;-------------------------------------------------------



comment $
͸
                                                                          
  Three procedures to print the Decimal values of EAX, AX                 
 and AL respectivly.                                                      
                                                                          
 $
; ***************  prints decimal EAX  ******************
Print_DecDword   PROC PASCAL  USES ESI
        mov     ESI,4*9
        call	DecSizeSet
        RET
Print_DecDword        ENDP


; ***************  prints decimal AX  ******************
Print_DecWord          PROC  PASCAL  USES ESI
        and     eax,0ffffh
        mov     ESI,4*4
        Call 	DecSizeSet
        RET
Print_DecWord        ENDP

; ***************  prints decimal AL  ******************
Print_DecByte        PROC PASCAL  USES  ESI
        and     eax,0ffh
        mov     ESI,4*2
        Call   DecSizeSet
        RET
Print_DecByte        ENDP
DecSizeSet PROC PASCAL   USES ECX EDX

        mov     ecx,eax
dec83:
        mov	eax,ECX
        xor	edx,edx
        div	cs:Dec_divider[ESI]
        mov	ECX,EDX		; reuse remainder
		add al,'0'	; use quotient as digit number
                call    Print_Char      ; send character to screen
        sub ESI,4
        jge dec83

	ret
align 4
dec_divider dd 1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000

DecSizeSet ENDP

;-------------------------------------------------------






comment $
͸
                                                                          
  Three procedures to print the Hexidecimal values of EAX, AX             
 and AL respectivly.                                                      
                                                                          
 $
; ***************  prints Hexidecimal EAX  ******************
Print_HexDword   PROC PASCAL    USES EDX
        mov dh,8
        Call  HexSizeSet
        RET
Print_HexDword        ENDP


; ***************  prints Hexidecimal AX  ******************
Print_HexWord       PROC PASCAL    USES  EDX
	mov dh,4
        rol eax,16
        Call  HexSizeSet
        RET
Print_HexWord        ENDP


; ***************  prints Hexidecimal AL  ******************
Print_HexByte       PROC PASCAL   USES  EDX
        mov dh,2
        rol eax,24
        Call   HexSizeSet
        RET
Print_HexByte        ENDP

HexSizeSet PROC NEAR
                push    ecx
                mov     ecx,eax
        Hexary_digit:
                rol     ecx,4
                mov     al,cl
                and     al,0Fh
                cmp   al,9
                ja J80
                     add     al,'0'
                     jmp J82
            J80:
                     add     al,'A'-10
            J82:

		call	Print_Char	; send character to screen
                dec     dh
                jnz	Hexary_digit
                pop    ecx
                ret
HexSizeSet ENDP

;-------------------------------------------------------





CODE32 ENDS
END



This is another print_char routine. this uses the BIOS instead of direct
 vidio access.

Print_Char      proc PASCAL  USES EAX ECX EBX
                cmp     al,0Ah
                je J32
                cmp al,0Dh
                je J32
                cmp     GlobalTextColor,-1
                je J32
 ;------- print the character on the screen ----------
                mov     bl,byte ptr GlobalTextColor
                mov     ah,09h
                mov     ecx,1
                xor     bh,bh
                dosint  10h
J32:
                mov     ah,0Eh      ; update the cursor, scroll screen, ect
                dosint  10h
                ret
Print_Char   EDNP
