CODE	 segment
	 assume  cs:CODE
	 org	 100h

POP_STR  struc

	 dw	 ?		; Caller's BP
POFF	 dw	 ?		; Caller's offset
PSEG	 dw	 ?		; Caller's segment
PFLG	 dw	 ?		; Caller's flags

POP_STR  ends

INITIAL:
	 jmp	 START

OLDINT08_VEC label dword
OLDINT08_OFF dw  ?
OLDINT08_SEG dw  ?

FLAG	 db	 0		; Stop flag

START:
	 xor	 ax,ax
	 mov	 ds,ax
	 assume  ds:nothing

	 cli
	 mov	 ax,offset cs:INT08
	 xchg	 ax,ds:[08h*4]
	 mov	 OLDINT08_OFF,ax

	 mov	 ax,cs
	 xchg	 ax,ds:[08h*4+2]
	 mov	 OLDINT08_SEG,ax
	 sti
	 cli			; Disable interrupts
POPF_AGAIN:
	 pushf
	 popf
POPF_NOP:
	 nop

	 cmp	 FLAG,0 	; Check flag
	 je	 POPF_AGAIN	; Go around again

	 ret			; Return to DOS
INT08:
	 pushf
	 call	 OLDINT08_VEC

	 sti			; Allow interrupts

	 push	 bp		; Prepare to address the stack
	 mov	 bp,sp		; Hello, Mr. Stack

	 push	 ax		; Save registers
	 push	 es

	 mov	 ax,cs

	 cmp	 ax,[bp].PSEG	; Same segment?
	 jne	 INT08_EXIT	; No, skip out

	 cmp	 [bp].POFF,offset cs:POPF_NOP ; Interrupted offset?
	 jne	 INT08_EXIT	; No, skip out

	 cli
	 les	 ax,OLDINT08_VEC ; Restore old handler
	 mov	 ds:[08h*4],ax
	 mov	 ds:[08h*4+2],es
	 mov	 FLAG,1 	; Mark as stopping
INT08_EXIT:
	 pop	 es		; Restore
	 pop	 ax

	 pop	 bp		; Restore

	 iret			; Return to interrupted instruction

CODE	 ends

	 end	 INITIAL
