;
; This code fragment will return the current CPU type in the ax register
; as shown. This processor detection code was modified from examples
; provided in the Intel i486 Programmers Reference Manual.
;

	.486

; Setup 16-bit code segment

_TEXT	SEGMENT WORD USE16 PUBLIC 'CODE'
	ASSUME	cs:_TEXT

get_cpu proc
	pushf				;save flags for exit
	pushf				;push flags again
	pop	bx			;get flags in bx
	and	bx, 0FFFH		;clear bits 12-15
	push	bx
	popf				;pop flags again
	pushf				;now push them back onto stack
	pop	ax			;get flags in ax
	and	ax, 0F000H		;mask off unwanted bits
	cmp	ax, 0F000H		;are flags 12-15 set?
	jz	cpu_86			;branch if so

	or	bx, 0F000H		;attempt to set flags again
	push	bx			;push to stack
	popf
	pushf				;push flags to stack
	pop	ax			;get flags in ax
	and	ax, 0F000H		;check flags 12-15
	jz	cpu_286			;branch if 286 processor

	mov	edx, esp  		;get stack pointer
	and	esp, NOT 3		;align stack to avoid AC fault
	pushfd
	pop	eax			;get 32-bit flags
	mov	ecx, eax
	xor	eax, 40000H		;flip AC bit in flags
	push	eax
	popfd				;get flags again
	pushfd				;push flags to stack
	pop	eax			;get the result
	mov	esp, edx		;restore stack
	xor	eax, ecx		;set if AC bity changed
	jnz	cpu_386			;branch if 386 cpu

	mov	ax, 486H		;set 80486 processor type
	jmp	short get_cpu_exit	;branch to exit

cpu_386:
	mov	ax, 386H		;set 80386 processor
	jmp	short get_cpu_exit	;branch to exit

cpu_286:
	mov	ax, 286H		;set 80286 processor type
	jmp	short get_cpu_exit	;branch to exit

cpu_86:
	mov	ax, 86H			;set processor type to 8086

get_cpu_exit:
	popf				;restore original flags
	ret
get_cpu ENDP

_TEXT	ENDS

	END

