;	DESC:	search for the next of a set of matching filenames   V1.00
;
;	***	CX must be loaded with the appropriate file attribute
;		to search on (1:read only,2:hidden file,
;		 4:system file,8:volume label,10H:sub-directory,
;		 20H:archived file).                              ***
;
;	IN:	*{SEG_VAL} segment and
;		*{OFFSET} offset of search string
;	OUT:	*{TIME} time file last written
;		*{DATE} date file last written
;		*{SIZE_LO} low word of file size
;		*{SIZE_HI} high word of file size
;		*{OUT_SEG} segment and
;		*{OUT_OFF} offset of first matching filename
;		*{LENGTH} length of filename found, 0 if not found
;	SAMPLE:	SRCH_NXT,<SEG_VAL,OFFSET>,
;		         <TIME,DATE,SIZE_LO,SIZE_HI,OUT_SEG,OUT_OFF,LENGTH>
;	################################################################

SRCH_FID Segment Para Common 'DATA'
TRANSFER	DB	80H DUP(0)		;temporary data transfer area.
THIRTY		DW	30			;value of number thirty.
SEGER		DW	0			;segment and offset of stored
OFFER		DW	0			;old data area.
SRCH_FID Ends
 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	GET_DSK:Near
	Extrn	SET_DSK:Near

SRCH_NXC	Segment
	Assume	CS:SRCH_NXC,DS:SRCH_FID
	Public	SRCH_NXT

						;notice.
	DB	'SRCH_NXT - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

SRCH_NXT	Proc	Near
	Call	PUSHALL				;save registers.

	Mov	AX,SRCH_FID			;load workarea.
	Mov	DS,AX

SRCHR:	Call	GET_DSK				;find current DTA.

	Pop	SEGER				;save DTA location.
	Pop	OFFER

	Push	DS				;setup new DTA.
	Mov	AX,OFFSET TRANSFER
	Push	AX
	Call	SET_DSK

	Mov	AX,4F00H			;continue search.

	Pop	DX				;recover filename segment
	Pop	DS				;and offset.

TOP:	Push	DS				;save filename info.
	Push	DX

	Int	21H

	Mov	AH,0				;save search results.
	Mov	DX,AX

	Mov	AX,SRCH_FID			;restore workarea.
	Mov	DS,AX

	Mov	BP,30				;load file area offset.

	Cmp	DX,0				;see if filename was there.
	Jnz	REST

ENDLOC:	Mov	AX,DS:WORD PTR[BP]		;determine length of filename.
	Cmp	AL,0
	Jz	REST
	Inc	BP
	Jmp	ENDLOC

REST:	Sub	BP,THIRTY			;length of filename.
	Jz	OK

	Cmp	CL,DS:BYTE PTR[21]		;check that files match
	Jz	OK				;search attribute.

	Pop	DX				;if not a good file then
	Pop	DS				;search for next match.

	Mov	AX,4F00H			;continue search.
	Jmp	TOP

OK:	Pop	AX				;discard filename info.
	Pop	AX

	Push	BP				;return filename length.
	Push	THIRTY				;offset and
	Push	DS				;segment of filename.
	Push	DS:WORD PTR[28]			;high word of file size.
	Push	DS:WORD PTR[26]			;low word of file size.
	Push	DS:WORD PTR[24]			;time file last written.
	Push	DS:WORD PTR[22]			;date file last written.

	Push	SEGER				;restore old DTA.
	Push	OFFER
	Call	SET_DSK

	Call	POPALL				;restore registers.
	Ret

SRCH_NXT	Endp

SRCH_NXC	Ends
	End
