;	DESC:	Scans a source buffer for given characters           V1.01
;		and returns the character and location of the closest
;		matching character
;
;	***	SCAN_BYT performs forward and reverse searches. The CLD
;		assembler command must be used before calling the procedure
;		to perform a forward search. The STD command must be used
;		before calling to perform a reverse search.     ***
;
;	IN:	*{MATCH2N} 2nd and additional matches
;		*{SEG_VAL} segment and
;		*{OFFSET} offset of buffer to scan
;		*{MATCH1} 1st of N number of possible matching sequences
;		*{N} number of matching sequences passed in
;	OUT:	*{MATCH_VAL} value of matching character
;		*{MATCH_LOC} location of offset in match segment where
;		 matching value was found
;	SAMPLE:	Callm	SCAN_BYT,<MATCH2N,SEG_VAL,OFFSET,MATCH1,N>,
;		                 <MATCH_VAL,MATCH_LOC>
;	##################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

SCAN_BYC	Segment
	Assume	CS:SCAN_BYC
	Public	SCAN_BYT

						;notice.
	DB	'SCAN_BYT - V1.01, Copyright 1987, CoreTechs   ',0DH,0AH

SCAN_BYT	Proc	Near

	Call	PUSHALL
	Pop	BX				;recover the number of
						;Possible matches.
	Pop	AX				;recover one possible match.
	Pop	SI				;recover offset of buffer.
	Pop	ES				;recover segment of buffer.

	Push	AX				;replace match on stack.
	Mov	DX,0FFFFH			;init. scan to buffer end.

	Pushf					;determine direction of scan.
	Pop	BP
	And	BP,0400H			;strip out direction bit.
	Jz	TOP				;if forward scan,ok.
	Mov	DX,0				;else, reset scanlo.

TOP:	Mov	DI,SI				;start scan at buffer start.
	Mov	CX,0FFFFH			;set repeat code to search
						;entire segment.
	Pop	AX				;get match.
	Repnz	SCASB				;scan for match.

	Pushf					;determine direction of scan.
	Pop	BP
	And	BP,0400H			;strip out direction bit.
	Jnz	DECR
	Dec	DI				;if up, then decrement DI
	Jmp	INCR
DECR:	Inc	DI				;if down, the increment DI.

	Cmp	DI,DX				;find nearest point in buffer.
	Jb	S1				;if not nearest, ignore.

	Cmp	DI,SI				;must be before buffer start.
	Jg	S1				;if not before buffer, ignore.
	Jmp	S2				;if acceptable,set new point.

INCR:	Cmp	DI,DX				;find nearest point in buffer.
	Jae	S1				;if not nearest, ignore.

	Cmp	DI,SI				;must be past buffer start.
	Jb	S1				;if not past BOB, ignore.

S2:	Mov	DX,DI				;save location of match.
	Mov	CS:WORD PTR[0],AX		;save match value.

S1:	Dec	BX				;are there any more matches?
	Jz	DONE				;if not, return.
	Jmp	TOP				;if yes, handle other matches.

DONE:	Push	DX				;return with location of match
	Push	CS:WORD PTR[0]			;and matching character.
	Call	POPALL
	Ret

SCAN_BYT	Endp
SCAN_BYC	Ends
	End
