;	DESC:	Reads data from a file                               V1.00
;	IN:	*{HANDLE} handle of file
;		*{NUM_BYTES} number of bytes requested to read from file
;		*{SEG_VAL} segment and
;		*{OFFSET} offset of buffer
;	OUT:	*{NUM_READ} number of bytes actually read
;	SAMPLE:	Callm	READ,<HANDLE,NUM_BYTES,SEG_VAL,OFFSET>,<NUM_READ>
;	################################################################## 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	ERRORMSG:Near

READC	Segment
	Assume	CS:READC
	Public	READ

						;notice.
	DB	'READ     - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

READ	Proc	NEAR				;reads a file.
	Call	PUSHALL

	Pop	DX				;get buffer offset.
	Pop	DS				;get buffer segment.
	Pop	CX				;get the number of bytes
						;to read.
	Pop	BX				;get the handle.

	Mov	AH,3FH				;read a file.
	Int	21H
	Jc	ERROR				;if an error report it.

	Push	AX
	Call	POPALL
	Ret

ERROR:	Push	AX				;report error and abort.
	Call	ERRORMSG

READ	Endp
READC	Ends
	End
