;	DESC:	Replaces one string with another string in a         V1.00
;		series of files of less than 40,000 bytes each.
;	IN:	*search string
;		*replacement string
;		*filename.ext with wildcards allowed.
;	OUT:	*all files meeting the file specification and having
;		a search string matching the input one have had the text
;		replaced with the replacement string.
;	SAMPLE:	FILE_MOD search string,replacement string,*.ASM
;	####################################################################

FIL_MODD Segment Para Public 'DATA'
		DW	0			;help message.
		DW	0
		DD	MHELP
		DW	EHELP
MHELP		DB	0DH,0AH,'               '
		DB	'DESC:   Replaces one string with another string'
		DB	0DH,0AH,'               '
		DB	'in a series of files of less than 40,000 bytes each.'
		DB	0DH,0AH,'               '
		DB	'IN:     *search string'
		DB	0DH,0AH,'               '
		DB	'        *replacement string'
		DB	0DH,0AH,'               '
		DB	'        *filename.ext with wildcards allowed.'
		DB	0DH,0AH,'               '
		DB	'OUT:    *all files meeting the file specification'
		DB	0DH,0AH,'               '
		DB	'and having a search string matching the input one'
		DB	0DH,0AH,'               '
		DB	'have had the text replaced with the replacement'
		DB	0DH,0AH,'               '
		DB	'string.'
		DB	0DH,0AH,'               '
		DB	'SAMPLE: FILE_MOD search string,'
		DB	0DH,0AH,'               '
		DB	'replacement string,*.ASM'
		DB	0DH,0AH,'               '
EHELP		DB	0

SIZEHI		DW	0			;high word of file size.
SIZELO		DW	0			;low word of file size.


INHNDL		DW	0			;input file handle.

RSEG		DW	0			;replacement string info.
ROFF		DW	0

SSEG		DW	0			;search string info.
SOFF		DW	0
SLEN		DW	0

BUFFER		DB	40000 Dup(0)		;entry buffer.
FIL_MODD Ends

	Extrn	SRCH_FIL:Near			;locate files matching the
						;search string.
	Extrn	ERRORMSG:Near			;prints error exit messages.
	Extrn	OPEN:Near				;opens file.
	Extrn	WRITE:Near			;writes to a file.
	Extrn	READ:Near			;reads from data file.
	Extrn	SRCH_NXT:Near			;searches for next match.
	Extrn	CLOSE:Near			;closes data files.
	Extrn	HELP:Near			;provides help information.
	Extrn	REPLACE:Near			;replace strings.
	Extrn	PARM_BRK:Near			;breaks up  parameter strings.

FIL_MODC	Segment Para Public 'CODE'
	Assume CS:FIL_MODC,DS:FIL_MODD

	Include	CALLM.MAC			;macro file which allows
						;input and output of
						;parameters to subroutines.
	DW	0,0,0,180,0,0,0

						;notice.
	DB	'FILE_MOD - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

FILE_MOD	Proc	Far			;main procedure.

	Push	DS				;store return address.
	Xor	AX,AX
	Push	AX

	Mov	BX,DS				;save initial data segment.

	Mov	AX,FIL_MODD			;assign data segment location.
	Mov	DS,AX

	Callm	HELP,<BX,AX>,<ES,BX,CX>		;get DOS data line
						;specifying files on which
						;to make listing.

	Callm	PARM_BRK,<ES,BX,CX>,<CX>	;break up multiple params.

	Cmp	CX,3				;if three params., OK.
	Jz	CONT0

	Callm	ERRORMSG,<22>,			;wrong number of params.

CONT0:	Pop	ES				;recover third param.
	Pop	BX
	Pop	CX

	Mov	CX,20H				;locate first filename.
	Callm	SRCH_FIL,<ES,BX>,<AX,AX,SIZELO,SIZEHI,ES,BX,CX>
	Jcxz	ERROR1				;exit if no matching files.

	Jmp	CONT2

ERROR1:	Callm	ERRORMSG,<2>,			;display no File(s) found.

CONT2:	Pop	RSEG
	Pop	ROFF
	Pop	AX

	Pop	SSEG
	Pop	SOFF
	Pop	SLEN

CONT3:	Cmp	SIZEHI,0			;if file is greater then
	Ja	TNXT				;40,000 bytes skip.

	Cmp	SIZELO,40000
	Ja	TNXT
	Jmp	CONT1

TNXT:	Jmp	SNXT

CONT1:	Callm	OPEN,<ES,BX,0>,<INHNDL>		;open input file.

						;read entry.
	Callm	READ,<INHNDL,40000,DS,<OFFSET BUFFER>>,<CX>

	Callm	CLOSE,<INHNDL>,			;close input file.

	Mov	DX,OFFSET BUFFER		;initialize buffer pointer.
P1:	Callm	REPLACE,<RSEG,ROFF,0,DS,DX,SLEN,SSEG,SOFF>,<AX,DX>

	Cmp	AX,0				;check for all replacements
	Jz	CHK1				;completed.

	Sub	DX,OFFSET BUFFER		;determine if end of file
	Cmp	DX,SIZELO			;is passed.
	Jae	CHK3

	Add	DX,OFFSET BUFFER
	Jmp	P1

CHK1:	Cmp	DX,0
	Jz	CHK3

	Sub	DX,OFFSET BUFFER		;determine if end of file
	Cmp	DX,SIZELO			;is passed.
	Jae	CHK3

	Add	DX,OFFSET BUFFER
	Jmp	P1

CHK3:	Callm	OPEN,<ES,BX,1>,<INHNDL>		;open input file to write.

						;write entry to file.
	Callm	WRITE,<INHNDL,CX,DS,<OFFSET BUFFER>>,<AX>

	Callm	CLOSE,<INHNDL>,			;close input file.

SNXT:	Mov	CX,20H				;locate first filename.
	Callm	SRCH_NXT,<ES,BX>,<AX,AX,SIZELO,SIZEHI,ES,BX,CX>
	Jcxz	ERROR2				;exit if no more files.
	Jmp	CONT3				;return to start of loop.

ERROR2:	Callm	ERRORMSG,<18>,			;display no More Files(s).

FILE_MOD	Endp
FIL_MODC	Ends
	End	FILE_MOD
