;	DESC:	Prints DOS error messages 1-18 and additional user   V1.01
;		 supplied messages from 19 up. If the value of ERR_NUM is
;		 0 control returns to the calling program with no effect.
;		 If ERR_NUM is greater than the value of the maximum error
;		 message then the message "No Error for This Value" is
;		 displayed and control returns to DOS. If an error code is
;		 displayed then control also returns to DOS. The memory
;		 address where the error occured is displayed on exit.
;	IN:	*{ERR_NUM} error number where the possible legal values are:
;		 1......Invalid Function Number
;		 2......File Not Found
;		 3......Path Not Found
;		 4......Too Many Open Files (no handles left)
;		 5......Access Denied
;		 6......Invalid Handle
;		 7......Memory Control Blocks Destroyed
;		 8......Insufficient Memory
;		 9......Invalid Memory Block Address
;		10......Invalid Environment
;		11......Invalid Format
;		12......Invalid Access Code
;		13......Invalid Data
;		14......This Error Does Not Exist
;		15......Invalid Drive Was Specified
;		16......Attempted To Remove The Current Directory
;		17......Not Same Device
;		18......No More Files
;		19......No Room For File(s) On Target Disk
;		20......No Filename(s) Specified
;		21......No Volume Label On Disk
;		22......Wrong Number of Parameters
;	        >22.....No Error for This Value
;	SAMPLE:	Callm	ERRORMSG,<ERR_NUM>,
;	##################################################################

ERRORMSD	Segment
ADDR1		DW	0			;error occurrence address.
ADDR2		DW	0
		DB	':'
ADDR3		DW	0
ADDR4		DW	0
		DB	' in '
NUMBER		DB	44
MAXERR		DW	23			;maximum error value.
CALLER		DW	0			;return location.
SNAME		DB	'CoreTechs'
						;error value conversion table.
MSG		DB	'Invalid Function Number                   at' ;1
		DB	'File Not Found                            at' ;2
		DB	'Path Not Found                            at' ;3
		DB	'Too Many Open Files (no handles left)     at' ;4
		DB	'Access Denied                             at' ;5
		DB	'Invalid Handle                            at' ;6
		DB	'Memory Control Blocks Destroyed           at' ;7
		DB	'Insufficient Memory                       at' ;8
		DB	'Invalid Memory Block Address              at' ;9
		DB	'Invalid Environment                       at' ;10
		DB	'Invalid Format                            at' ;11
		DB	'Invalid Access Code                       at' ;12
		DB	'Invalid Data                              at' ;13
		DB	'This Error Does Not Exist                 at' ;14
		DB	'Invalid Drive Was Specified               at' ;15
		DB	'Attempted To Remove The Current Directory at' ;16
		DB	'Not Same Device                           at' ;17
		DB	'No More Files                             at' ;18
		DB	'No Room For File(s) On Target Disk        at' ;19
		DB	'No Filename(s) Specified                  at' ;20
		DB	'No Volume Label On Disk                   at' ;21
		DB	'Wrong Number of Parameters                at' ;22
		DB	'No Error for This Value                   at' ;>22
ERRORMSD	Ends

	Extrn	PUSHALL:Near
	Extrn	CURS_SET:Near
	Extrn	POPALL:Near
	Extrn	TEXT_WRT:Near
	Extrn	HEX_ASC:Near
	Extrn	HEXDSPLY:Near
	Extrn	SEARCH:Near			;locates matching strings.

ERRORMSC	Segment
	Assume	CS:ERRORMSC,DS:ERRORMSD
	Public	ERRORMSG

	Include	CALLM.MAC

						;notice.
	DB	'ERRORMSG - V1.01, Copyright 1987, CoreTechs   ',0DH,0AH

ERRORMSG	Proc	Near
						;this section has the effect
						;of placing the return address
						;for the erroring program on
						;the stack as another
						;parameter.
	Pop	CS:WORD PTR[0]			;store return address.
	Pop	CS:WORD PTR[2]			;store error value.
	Push	CS:WORD PTR[0]			;replace return address.
	Push	CS:WORD PTR[2]			;replace error value.
	Push	CS:WORD PTR[0]			;replace return address.

	Call	PUSHALL				;save registers.

	Mov	AX,ERRORMSD			;setup workarea.
	Mov	DS,AX

	Mov	BP,OFFSET MSG			;load error table offset.
	Pop	AX				;recover error value.
	Mov	AH,0				;error is in the range (0-255)

	Pop	DX				;recover IP.
	Push	DX				;restore IP.

						;save return address for
	Mov	CALLER,DX			;error message.

	Cmp	AX,0				;if error is 0, then no error.
	Jnz	ERROR
	Jmp	OUTIN

ERROR:	Cmp	AX,MAXERR			;if error is greater then or
	Jb	ERROR1				;equal to the highest error
	Mov	AX,MAXERR			;then use the highest error.

ERROR1:	Dec	AX				;decrement to get offset.
	Mul	NUMBER				;offset is mult. of NUMBER.

	Add	BP,AX				;find total offset.

	Mov	AL,NUMBER			;find offset to end of mess.
	Mov	AH,0
	Add	AX,BP

						;display error message.
	Callm	TEXT_WRT,<0,1800H,DS,BP,AX>,

	Callm	HEXDSPLY,<CS>,<AX,BX>		;prepare CS for display.
	Xchg	AH,AL				;flip bytes.
	Xchg	BH,BL				;flip bytes.
	Mov	ADDR1,AX			;store CS.
	Mov	ADDR2,BX

	Pop	AX				;recover IP.

	Callm	HEXDSPLY,<AX>,<AX,BX>		;prepare IP for display.
	Xchg	AH,AL				;flip bytes.
	Xchg	BH,BL				;flip bytes.
	Mov	ADDR3,AX			;store CS.	
	Mov	ADDR4,BX

	Mov	BP,OFFSET ADDR1			;display error address.
	Add	BP,13
	Callm	TEXT_WRT,<0,1830H,DS,<OFFSET ADDR1>,BP>,

	Mov	BX,CALLER			;locate error module.
	Callm	SEARCH,<1,CS,BX,9,DS,<OFFSET SNAME>>,<AX,BX>

	Sub	BX,22H				;display module where error
	Mov	DX,BX				;occurred.
	Add	DX,8
	Callm	TEXT_WRT,<0,183EH,AX,BX,DX>,

						;position cursor at bottom
	Callm	CURS_SET,<1800H,0>,		;of screen at exit.

	Mov	AH,4CH				;return to DOS.
	Int	21H

OUTIN:	Pop	AX				;normal recovery to calling
	Call	POPALL				;program.
	Ret

ERRORMSG	Endp
ERRORMSC	Ends
	End
