;	DESC:	Creates a file with a descriptive listing of all     V1.00
;	files matching the search string. The search string is in the format
;	of a filename. The filename may be specified with both the *
;	and ? wildcard characters. The listing file is in file Filelist.Dir.
;	The format of the files to be listed must be as
;	follows to list properly.
;	1) Text starts at Line One.
;	2) Each line begins with eight spaces or characters before the text.
;	3) Each line ends on or before the 78th column.
;	4) The listing portion of the file ends with all number signs {#}.
;	5) The entire listing is no more than 5000 bytes {approx. 50 lines.}
;	IN:	*filename.ext with wildcards allowed.
;	OUT:	*file called "FILELIST.DIR" with listing of all files
;		fitting conditions specified in search.
;	SAMPLE:	DIR_FILE *.ASM {all files with a .ASM extension}
;	####################################################################


DIR_FILD Segment Para Public 'DATA'
		DW	0			;help message.
		DW	0
		DD	MHELP
		DW	EHELP
MHELP		DB	0DH,0AH,'               '
		DB	'DESC:   Creates a file with a descriptive listing of'
		DB	0DH,0AH,'               '
		DB	'all files matching the search string. The search'
		DB	0DH,0AH,'               '
		DB	'string is in the format of a filename. The filename'
		DB	0DH,0AH,'               '
		DB	'may be specified with both the * and ? wildcard'
		DB	0DH,0AH,'               '
		DB	'characters. The listing file is in file Filelist.Dir'
		DB	0DH,0AH,'               '
		DB	'The format of the files to be listed must be as'
		DB	0DH,0AH,'               '
		DB	'follows to list properly.'
		DB	0DH,0AH,'               '
		DB	'1) Text starts at Line One.'
		DB	0DH,0AH,'               '
		DB	'2) Each line begins with eight spaces or characters'
		DB	0DH,0AH,'               '
		DB	'before the text.'
		DB	0DH,0AH,'               '
		DB	'3) Each line ends on or before the 78th column.'
		DB	0DH,0AH,'               '
		DB	'4) The listing portion of the file ends with all'
		DB	0DH,0AH,'               '
		DB	'number signs {#}. {At least two}'
		DB	0DH,0AH,'               '
		DB	'5) The entire listing is no more than 5000 bytes'
		DB	0DH,0AH,'               '
		DB	'{approx. 50 lines.}'
		DB	0DH,0AH,'               '
		DB	'IN:     filename.ext with wildcards allowed.'
		DB	0DH,0AH,'               '
		DB	'OUT:    file called "FILELIST.DIR" with listing of'
		DB	0DH,0AH,'               '
		DB	'all files fitting conditions specified in search.'
		DB	0DH,0AH,'               '
		DB	'SAMPLE: DIR_FILE *.ASM {all files ending with .ASM}.'
EHELP		DB	0

DATE		DW	0			;date file last modified.
SIZEHI		DW	0			;high word of file size.
SIZELO		DW	0			;low word of file size.


INHNDL		DW	0			;input file handle.

OUTFILE		DB	'Filelist.Dir',0	;output file name.
OUTHNDL		DW	0			;output file handle.

S1		DW	0			;filesize blocks.
S2		DW	0
S3		DW	0
S4		DW	0
S5		DW	0
CR		DW	0A0DH			;carriage return.

FILLER		DB	20 Dup(20H)		;blank filler.

BUFFER		DB	5000 Dup(0)		;entry buffer.
DIR_FILD Ends

	Extrn	SRCH_FIL:Near			;locate files matching the
						;search string.
	Extrn	ERRORMSG:Near			;prints error exit messages.
	Extrn	OPEN:Near				;opens file.
	Extrn	CREATE:Near			;creates a file.
	Extrn	FILEDATE:Near			;converts file date to ASCII.
	Extrn	WRITE:Near			;writes to a file.
	Extrn	HEX_ASC:Near			;converts hex to ASCII.
	Extrn	SCAN_WRD:Near			;scans for matching strings.
	Extrn	SCAN_BYT:Near			;scans for matching bytes.
	Extrn	READ:Near			;reads from data file.
	Extrn	SRCH_NXT:Near			;searches for next match.
	Extrn	CLOSE:Near			;closes data files.
	Extrn	HELP:Near			;provides help information.

DIR_FILC	Segment Para Public 'CODE'
	Assume CS:DIR_FILC,DS:DIR_FILD

	Include	CALLM.MAC			;macro file which allows
						;input and output of
						;parameters to subroutines.
	DW	0,0,0,180,0,0,0

						;notice.
	DB	'DIR_FILE - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

DIR_FILE	Proc	Far			;main procedure.

	Push	DS				;store return address.
	Xor	AX,AX
	Push	AX

	Mov	BX,DS				;save initial data segment.

	Mov	AX,DIR_FILD			;assign data segment location.
	Mov	DS,AX

	Callm	HELP,<BX,AX>,<ES,BX,CX>		;get DOS data line
						;specifying files on which
						;to make listing.

	Mov	CX,20H				;locate first filename.
	Callm	SRCH_FIL,<ES,BX>,<AX,DATE,SIZELO,SIZEHI,ES,BX,CX>
	Jcxz	ERROR1				;exit if no matching files.
	Jmp	CONT1

ERROR1:	Callm	ERRORMSG,<2>,			;display no File(s) found.

						;create output file.
CONT1:	Callm	CREATE,<DS,<OFFSET OUTFILE>,0>,<OUTHNDL>

CONT2:	Callm	OPEN,<ES,BX,0>,<INHNDL>		;open input file.

	Callm	WRITE,<OUTHNDL,CX,ES,BX>,<AX>	;write the filename to file.

	Mov	AX,20				;pad with blanks.
	Sub	AX,CX				;fill in string.
						;write filler.
	Callm	WRITE,<OUTHNDL,AX,DS,<OFFSET FILLER>>,<AX>

	Callm	FILEDATE,<DATE>,<AX,BX>		;convert filedate to ASCII.

						;write the filedate to file.
	Callm	WRITE,<OUTHNDL,8,AX,BX>,<AX>

						;get file size in ASCII.
	Callm	HEX_ASC,<SIZEHI,SIZELO>,<S1,S2,S3,S4,S5>

	Mov	AX,S1				;flip numbers.
	Xchg	AH,AL
	Mov	S1,AX
	Mov	AX,S2				;flip numbers.
	Xchg	AH,AL
	Mov	S2,AX
	Mov	AX,S3				;flip numbers.
	Xchg	AH,AL
	Mov	S3,AX
	Mov	AX,S4				;flip numbers.
	Xchg	AH,AL
	Mov	S4,AX
	Mov	AX,S5				;flip numbers.
	Xchg	AH,AL
	Mov	S5,AX

	Callm	WRITE,<OUTHNDL,12,DS,<OFFSET S1>>,<AX>	;write file size.

						;read entry.
	Callm	READ,<INHNDL,5000,DS,<OFFSET BUFFER>>,<CX>

	Cld					;perform forward search for
						;multiple periods.
	Callm	SCAN_WRD,<DS,<OFFSET BUFFER>,2323H,1>,<AX,CX>

	Std					;search for previous return.
	Callm	SCAN_BYT,<DS,CX,000DH,1>,<AX,CX>

	Sub	CX,OFFSET BUFFER		;find length of entry.

						;write entry to file.
	Callm	WRITE,<OUTHNDL,CX,DS,<OFFSET BUFFER>>,<AX>

						;add carriage returns.
	Callm	WRITE,<OUTHNDL,2,DS,<OFFSET CR>>,<AX>
	Callm	WRITE,<OUTHNDL,2,DS,<OFFSET CR>>,<AX>

	Callm	CLOSE,<INHNDL>,			;close input file.

	Mov	CX,20H				;locate first filename.
	Callm	SRCH_NXT,<ES,BX>,<AX,DATE,SIZELO,SIZEHI,ES,BX,CX>
	Jcxz	ERROR2				;exit if no more files.
	Jmp	CONT2				;return to start of loop.

ERROR2:	Callm	CLOSE,<OUTHNDL>,		;close listing file.
	Callm	ERRORMSG,<18>,			;display no More Files(s).

DIR_FILE	Endp
DIR_FILC	Ends
	End	DIR_FILE
