;	DESC:	Gets the system time                                 V1.00
;	OUT:	*{SEG_VAL} segment address and
;		*{OFFSET} offset within segment of time in ASCII printable
;		 format. Time is in format HH:MM:SS.XX
;	SAMPLE:	Callm	TIME_GET,,<SEG_VAL,OFFSET>
;	##################################################################

TIME_GED	Segment
HOUR		DW	0			;time block.
		DB	':'
MINUTE		DW	0
		DB	':'
SECOND		DW	0
		DB	'.'
HUNDRED		DW	0
		DB	0
TIME_GED	Ends

	Extrn	HEX_ASC:Near			;convert hex to ASCII.
	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

TIME_GEC	Segment
	Assume	CS:TIME_GEC,DS:TIME_GED
	Public	TIME_GET

	Include	CALLM.MAC
						;notice.
	DB	'TIME_GET - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

TIME_GET	Proc	Near

	Call	PUSHALL				;save registers.

	Mov	AX,TIME_GED			;setup workarea.
	Mov	DS,AX

	Mov	AH,2CH				;get system time.
	Int	21H

	Mov	BH,0				;break out hour.
	Mov	BL,CH
	Callm	HEX_ASC,<0,BX>,<AX,AX,AX,AX,AX>
	Xchg	AH,AL
	Mov	HOUR,AX

	Mov	CH,0				;break out minutes.
	Callm	HEX_ASC,<0,CX>,<AX,AX,AX,AX,AX>
	Xchg	AH,AL
	Or	AX,3030H
	Mov	MINUTE,AX

	Xor	BX,BX				;break out seconds.
	Mov	BL,DH
	Callm	HEX_ASC,<0,BX>,<AX,AX,AX,AX,AX>
	Xchg	AH,AL
	Or	AX,3030H
	Mov	SECOND,AX

	Mov	DH,0				;break out hundreds of
	Callm	HEX_ASC,<0,DX>,<AX,AX,AX,AX,AX>	;seconds.
	Xchg	AH,AL
	Or	AX,3030H
	Mov	HUNDRED,AX

	Mov	DX,OFFSET HOUR			;return pointer to
	Push	DX				;time block.
	Push	DS

	Call	POPALL				;restore registers.
	Ret

TIME_GET	Endp
TIME_GEC	Ends
	End
