;	DESC:	Writes text to screen                                V1.02
;	IN:	*{ATTRIB_PAGE} attribute used to display text (00-FFH),
;		 page number to write on (0-3)
;		*{ROWCOL} row(0-24), col(0-79) row and column to start writing
;		 at.
;		*{SEG_VAL} segment of text and
;		*{OFFSET} offset of text
;		*{END_OFF} offset end text
;	SAMPLE:	Callm	TEXT_WRT,<PAGE,ROWCOL,SEG_VAL,OFFSET,END_OFF>,
;	######################################################################

TEXT_WRD Segment Para Public 'DATA'
ATRIB		DB	7
PAGEL		DW	0
LINE		DB	160
TEXT_WRD Ends
 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SCRN_TYP:Near

TEXT_WRC	Segment
	Assume	CS:TEXT_WRC,DS:TEXT_WRD
	Public	TEXT_WRT

						;notice.
	DB	'TEXT_WRT - V1.02, Copyright 1987, CoreTechs   ',0DH,0AH

TEXT_WRT	Proc	Near			;load the screen from memory.

	Call	PUSHALL				;save registers.

	Mov	AX,TEXT_WRD			;set up workarea.
	Mov	DS,AX

	Call	SCRN_TYP			;determine color or b&w.
	Pop	BX

COLOR:	Mov	AX,4096				;determine page offset.

	Pop	ES				;recover offset end of text.
	Pop	DX				;recover offset of text.
	Pop	SI				;recover segment of text.
	Pop	DI				;recover row and column.
	Pop	CX				;recover page number.

	Push	ES				;replace offset end of text.
	Push	DX				;replace offset of text.
	Push	SI				;replace segment of text.
	Push	DI				;replace row and column.

	Cmp	CH,0				;if no attribute is passed
	Jnz	T1				;in, then set to white on
	Mov	CH,7				;black.

T1:	Mov	ATRIB,CH			;store attribute if passed.

	Mov	CH,0				;clear attribute.

	Mov	PAGEL,CX			;determine page offset in
	Mul	PAGEL				;video memory.

	Mov	CL,4				;divide by 16 to get
	Shr	AX,CL				;segment value

	Add	BX,AX
	Mov	ES,BX				;get absolute segment.
	
	Pop	AX				;determine offset of
	Mov	BX,AX				;row, col on screen.
	Xchg	AH,AL

	Mov	AH,0				;find row offset.
	Mul	LINE

	Mov	BH,0				;cloumn offset is twice value
	Shl	BX,1				;passed in.

	Add	AX,BX				;store total offset into page
	Mov	DI,AX				;in DI.

	Pop	DS				;segment of text.
	Pop	SI				;offset of text.

	Pop	CX				;offset of the end of text.
	Sub	CX,SI

	Mov	BP,TEXT_WRD			;prepare for write operation.

CONT:	Cmp	DS:WORD PTR[SI],0A0DH		;skip to new line of screen
	Jz	NEWLN				;when carriage return found.

	Cmp	DI,4096				;exit if page end is passed.
	Jl	NOTEND
	Jmp	READY

NOTEND:	Cld					;move text to screen.
	Movs	ES:BYTE PTR[DI],DS:[SI]		;move text.
	Dec	CX
	Push	SI
	Push	CX
	Push	BP
	Push	DS
	Pop	BP
	Pop	DS
	Mov	SI,OFFSET ATRIB
	Cld

	Movs	ES:BYTE PTR[DI],DS:[SI]		;move attribute.
	Push	BP
	Push	DS
	Pop	BP
	Pop	DS
	Pop	CX
	Pop	SI
	Cmp	CX,0				;exit when count is done.
	Jz	READY
	Jmp	CONT

NEWLN:	Add	SI,2				;modifications made to account
	Sub	CX,2				;for extra characters being
	Mov	AX,DI				;added becuase of CRLF.

	Push	BP				;determine new line info.
	Push	DS
	Pop	BP
	Pop	DS
	Div	LINE

	Push	BP
	Push	DS
	Pop	BP
	Pop	DS
	Inc	AL
	Mov	AH,0
	Push	BP
	Push	DS
	Pop	BP
	Pop	DS
	Mul	LINE
	Push	BP
	Push	DS
	Pop	BP
	Pop	DS
	Mov	DI,AX
	Jmp	CONT

READY:	Call	POPALL
	Ret

TEXT_WRT	Endp
TEXT_WRC	Ends
	End
