;	DESC:	Reads text from the screen                           V1.00
;	IN:	*{PAGE} page number of screen (0-3)
;		*{ROWCOL} row(0-24), col(0-79) (i.e. 0345) at which to
;		 begin reading from screen
;		*{NUM_CHARS} # of chars to read
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of string read
;	SAMPLE:	Callm	TEXT_RD,<PAGE,ROWCOL,NUM_CHARS>,<SEG_VAL,OFFSET>
;	##################################################################

TEXT_RDD Segment Para Public 'DATA'
STRNG		DB	80 DUP(0)
PAGEL		DW	0
LINE		DB	160
TEXT_RDD Ends

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SCRN_TYP:Near

TEXT_RDC	Segment
	Assume	CS:TEXT_RDC,DS:TEXT_RDD
	Public	TEXT_RD

						;notice.
	DB	'TEXT_RD  - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

TEXT_RD	Proc	Near				;read text from the screen.

	Call	PUSHALL				;save registers.

	Mov	AX,TEXT_RDD			;setup workarea.
	Mov	DS,AX	

	Call	SCRN_TYP			;determine video memory
	Pop	BX				;location.

COLOR:	Mov	AX,4096				;load page length.

	Pop	SI				;recover number of chars.
	Pop	DI				;recover row, column offset.
	Pop	CX				;recover page number.

	Push	SI				;replace number of chars.
	Push	DI				;replace row,column offset.

	Mov	PAGEL,CX			;find page offset.
	Mul	PAGEL

	Mov	CL,4				;divide by 16 to get
	Shr	AX,CL				;segment value.

 	Add	BX,AX				;load absolute video segment
	Mov	ES,BX				;in ES.
	
	Pop	AX				;determine offset of
	Mov	BX,AX				;row, col on screen.

	Xchg	AH,AL				;change rows to byte offset.
	Mov	AH,0
	Mul	LINE

	Mov	BH,0				;modify column information
	Shl	BX,1				;to reflect 160 bytes per
	Add	AX,BX				;line including attributes.

	Mov	SI,AX				;total offset to start read.

	Pop	CX				;recover # of chars to read.

	Push	DS				;prepare to transfer video
	Push	ES				;memory to internal buffer.
	Pop	DS
	Pop	ES
	Mov	DI,OFFSET STRNG
	Push	DI
	Push	ES

GETSTR:	Cld					;begin transfer.
	Movs	ES:BYTE PTR[DI],DS:[SI]	

	Inc	SI				;skip attributes.

	Dec	CX				;count down transfer.

	Cmp	CX,0				;are we done?
	Jz	OUTING

	Jmp	GETSTR				;if not done, continue.

OUTING:	Call	POPALL				;restore and return.
	Ret

TEXT_RD	Endp
TEXT_RDC	Ends
	End
