;	DESC:	Moves the file read/write pointer                    V1.00
;	IN:	*{METH_VAL} Method value
;		 (0:ofst,1:ofst+cloc,2:eof+offset)
;		*{HANDLE} handle
;		*{MSW} most significant word of offset
;		*{LSW} least significant word of offset
;	OUT:	*{OMSW} most significant word of pointer location
;		*{OLSW} least significant word of pointer location
;	SAMPLE:	Callm	MOV_PTR,<METH_VAL,HANDLE,MSW,LSW>,<OMSW,OLSW>
;	################################################################## 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	ERRORMSG:Near			;report error messages.

MOV_PTRC	Segment
	Assume	CS:MOV_PTRC
	Public	MOV_PTR

						;notice.
	DB	'MOV_PTR  - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

MOV_PTR	Proc	Near				;moves file read/write ptrs.
	Call	PUSHALL

	Pop	DX				;get lsw of offset.
	Pop	CX				;get msw of offset.
	Pop	BX				;get handle.
	Pop	AX				;get method value.

	Mov	AH,42H				;moves file read/write ptr.
	Int	21H
	Jc	ERROR				;if an error report it.

	Push	AX				;return lsw offset.
	Push	DX				;return msw offset.
	Call	POPALL
	Ret

ERROR:	Push	AX				;report error and abort.
	Call	ERRORMSG

MOV_PTR	Endp
MOV_PTRC	Ends
	End
