;	DESC:	Loads and Executes another program                   V1.00
;	IN:	*{SEG_VAL} segment and
;		*{OFFSET} offset of filename to run including extension
;		*{PAR_HI} high word and
;		*{PAR_LO} low word of pointer to command line
;		 to be passed to new program. Command line should be in the
;		 form N,' ',PARAM,0DH where N is the length of PARAM+1, and is
;		 followed by a space. PARAM is the command line and 0DH is
;		 a carriage return ending the line.
;		*{MEMBLK} segment value of last memory control block 
;		 segment is typically the value of DS at entry to the main
;		 program.
;		*{SIZE} size of main calling program in segment form
;	SAMPLE:	Callm	EXECUTE,<SEG_VAL,OFFSET,PAR_HI,PAR_LO,MEMBLK,SIZE>,
;	###################################################################

EXECUTED Segment Para Public 'DATA'
FCB1		DB	0,11 DUP(20),4 DUP(0)	;default FCB.

PBLOCK		DW	0			;parameter block.
PARAML		DW	0			;parameter offset
PARAMH		DW	0			;and segment.
		DD	FCB1
		DD	FCB1
EXECUTED Ends

	Extrn	PUSHALL:Near			;save and restore registers.
	Extrn	POPALL:Near
	Extrn	ERRORMSG:Near			;display error messages.
	Extrn	ALOC_CHG:Near			;change memory allocation.

EXECUTEC	Segment Para Public 'CODE'
	Assume CS:EXECUTEC,DS:EXECUTED
	Public	EXECUTE

SSEG		DW	0			;save stack segment.
SPTR		DW	0			;save stack pointer.

	Include	CALLM.MAC			;macro call program.

						;notice.
	DB	'EXECUTE  - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

EXECUTE	Proc	Near

	Call	PUSHALL				;save registers.

	Mov	AX,EXECUTED			;load workarea.
	Mov	DS,AX

	Pop	BX				;size of current program.
	Pop	ES				;recover memory control block.
	Pop	PARAML				;low word of parametr pointer.
	Pop	PARAMH				;high word of param. pointer.

	Callm	ALOC_CHG,<ES,BX>,		;change memory allocation.

	Mov	AX,DS
	Mov	ES,AX				;set ES:DX to segment and
	Mov	BX,OFFSET PBLOCK		;offset of parameter block.

	Pop	DX				;offset of command filename.
	Pop	DS				;segment of command filename.

	Mov	AX,4B00H			;EXEC function.

	Mov	CS:[SSEG],SS			;save stack.
	Mov	CS:[SPTR],SP

	Int	21H				;call DOS.

	Mov	SP,CS:[SPTR]			;restore stack.
	Mov	SS,CS:[SSEG]

	Jc	ERROR				;if error notify.

	Call	POPALL
	Ret

ERROR:	Push	AX				;error return.
	Call	ERRORMSG

EXECUTE	Endp
EXECUTEC	Ends
	End
