;	DESC:	Copies existing file to new or existing file         V1.00
;		using complete path names
;	IN:	*{OUT_SEG_VAL} segment and
;		*{OUT_OFFSET} offset of new filename
;		*{IN_SEG_VAL} segment and
;		*{IN_OFFSET} offset of old filename
;	SAMPLE:	Callm	COPY,<OUT_SEG_VAL,OUT_OFFSET,IN_SEG_VAL,IN_OFFSET>,
;	###################################################################

COPYD Segment Para Public 'DATA'
INHNDL		DW	0			;input file handle.
OUTHNDL		DW	0			;output file handle.
BUFFER		DB	4096 DUP(0)		;data buffer for transfer.
SEGIN		DW	0			;old filename location.
OFFIN		DW	0
SEGIN2		DW	0			;new filename location.
OFFIN2		DW	0
STRNG1		DB	'Copying '		;data strings.
STRNG2		DB	' to '
COPYD	Ends

	Extrn	PUSHALL:Near			;handle registers.
	Extrn	POPALL:Near
	Extrn	TEXT_WRT:Near			;display messages.
	Extrn	SCAN_BYT:Near			;search for strings.
	Extrn	ERRORMSG:Near			;display errors.
	Extrn	DELETE:Near			;delete files.
	Extrn	OPEN:Near			;open files.
	Extrn	READ:Near			;read from data file.
	Extrn	WRITE:Near			;write to file.
	Extrn	CREATE:Near			;create file.
	Extrn	CLOSE:Near			;close file.

COPYC	Segment
	Assume	CS:COPYC,DS:COPYD
	Public	COPY

	Include	CALLM.MAC			;calling macro.
						;notice.
	DB	'COPY     - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

COPY	Proc	Near
	Call	PUSHALL

	Mov	AX,COPYD			;set up workarea.
	Mov	DS,AX

	Pop	OFFIN				;old filename specs.
	Pop	SEGIN
	Pop	OFFIN2				;new filename specs.
	Pop	SEGIN2

	Mov	AX,OFFSET STRNG1		;display 'copying' message.
	Add	AX,8
	Callm	TEXT_WRT,<0,1800H,DS,<OFFSET STRNG1>,AX>,

						;find end of filename.
	Callm	SCAN_BYT,<SEGIN,OFFIN,0,1>,<DX,DX>

						;display old filename.
	Callm	TEXT_WRT,<0,1809H,SEGIN,OFFIN,DX>,

	Mov	AX,OFFSET STRNG2		;display 'to' message.
	Add	AX,4
	Callm	TEXT_WRT,<0,1820H,DS,<OFFSET STRNG2>,AX>,

						;find end of filename.
	Callm	SCAN_BYT,<SEGIN2,OFFIN2,0,1>,<DX,DX>

						;display new filename.
	Callm	TEXT_WRT,<0,1824H,SEGIN2,OFFIN2,DX>

	Callm	OPEN,<SEGIN,OFFIN,0>,<INHNDL>	;open the old file.

						;create output file.
	Callm	CREATE,<SEGIN2,OFFIN2,0>,<OUTHNDL>

						;read a block from input file.
TOP:	Callm	READ,<INHNDL,4096,DS,<OFFSET BUFFER>>,<CX>

	JCXZ	DONE				;if nothing read, eof.

						;write to the output file.
	Callm	WRITE,<OUTHNDL,CX,DS,<OFFSET BUFFER>>,<AX>

	Cmp	AX,CX				;number of chars. written.
	Je	TOP				;must equal num of chars read.

	Callm	CLOSE,<OUTHNDL>,		;close output file.

	Callm	DELETE,<SEGIN2,OFFIN2>,		;delete incomplete file.

	Callm	ERRORMSG,<19>,			;load error status.

DONE:	Callm	CLOSE,<INHNDL>,			;close input file.

	Callm	CLOSE,<OUTHNDL>,		;close output file.

	Call	POPALL
	Ret
COPY	Endp
COPYC	Ends
	End
