
title RESET STAT1 ERROR BITS
include subfx.h

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX 75503

;******************************************************************************
; ASYNC_RESET -- Resets bits 0-4 of the STAT1 byte.  Returns R_OK if successful
;                else returns R_NOPORT.
;
;   STAT1: 0=rx bufr ovrfl   1=char overrun     2=parity err    3=framing err
;          4=break intrpt    5=invalid port     6=rx bufr empty 7=no carrier
;******************************************************************************

begseg          COMM_TEXT
publicproc      _async_reset
        push    bp
        mov     bp,sp
        push    si              ;stack frame setup
        call    __ck_port_arg   ;ck if valid, load pointers
        jz      reset_exit      ;bad arg if ZR flag set
        and     STAT1,11100000b ;reset STAT1 error bits
        xor     ax,ax           ;return R_OK if success
reset_exit:
        pop     si
        pop     bp
        ret                     ;restore regs and exit
_async_reset    endp

endseg          COMM_TEXT
        end
